/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.entities.Moon;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.List;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhysicsEntity
extends Entity {
    private static final float OUT_OF_BOUNDS_PADDING = 20.0f;
    private Joint joint;
    private PhysicsEntity orbitTarget = null;
    private List<PhysicsEntity> orbitingTargets = new ArrayList<PhysicsEntity>();
    private float orbitSpeed = 0.0f;
    private float orbitDistance = 0.0f;

    public PhysicsEntity(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public boolean doesCauseGravity() {
        return false;
    }

    public boolean isInOrbit() {
        return this.orbitTarget != null;
    }

    public PhysicsEntity getOrbitTarget() {
        return this.orbitTarget;
    }

    public float getOrbitDistance() {
        return this.orbitDistance;
    }

    public List<PhysicsEntity> getOrbiters() {
        return this.orbitingTargets;
    }

    @Override
    public void destroy(GameWorld world) {
        this.destroyOrbit(world);
        for (PhysicsEntity pe : new ArrayList<PhysicsEntity>(this.orbitingTargets)) {
            pe.destroyOrbit(world);
        }
        super.destroy(world);
    }

    public void destroyOrbit(GameWorld world) {
        if (this.orbitTarget != null) {
            world.getPhysicsWorld().destroyJoint(this.joint);
            this.joint = null;
            this.orbitTarget.orbitingTargets.remove(this);
            this.orbitTarget = null;
        }
    }

    public void createOrbit(GameWorld world, PhysicsEntity around, float distance, float speed) {
        if (this.orbitTarget != null) {
            this.destroyOrbit(world);
        }
        if (around != null && around.getBody() != null) {
            Body body1 = around.getBody();
            DistanceJointDef def = new DistanceJointDef();
            def.initialize(this.body, body1, this.body.getWorldCenter(), body1.getWorldCenter());
            def.length = distance;
            def.dampingRatio = 0.9f;
            def.frequencyHz = 1.0f;
            def.collideConnected = true;
            this.joint = world.getPhysicsWorld().createJoint(def);
            this.orbitSpeed = speed;
            around.orbitingTargets.add(this);
            this.orbitTarget = around;
            this.orbitDistance = distance;
        }
    }

    @Override
    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.body != null) {
            float arenaBoundRadius = world.getEntities().getOne(ArenaBounds.class).getArenaRadius();
            float distanceFromOrigin = this.body.getWorldCenter().length();
            float distanceOutOfBounds = distanceFromOrigin - arenaBoundRadius;
            if (distanceOutOfBounds > 0.0f) {
                this.doOnOutOfBounds(world, distanceOutOfBounds);
            }
        }
        if (this.orbitTarget != null) {
            if (this.orbitTarget.getBody() == null || this.getBody() == null) {
                this.createOrbit(world, null, 0.0f, 0.0f);
            } else {
                Vec2 dir = this.getBody().getPosition().sub(this.orbitTarget.getBody().getPosition());
                dir.normalize();
                Vec2 relativeVelocity = this.orbitTarget.getBody().getLinearVelocity().sub(this.getBody().getLinearVelocity());
                Vec2 orbit = new Vec2(dir.y, -dir.x);
                if (Math.abs(Vec2.dot(orbit, relativeVelocity)) < this.orbitSpeed) {
                    this.body.applyForce(orbit.mul(1.0f * this.getBody().getMass()), this.body.getWorldCenter());
                }
            }
        }
    }

    @Override
    public void debug(Graphics g, GameWorld world, GameContainer container) {
        super.debug(g, world, container);
        if (this.joint != null) {
            float s = 100.0f;
            g.setColor(Color.yellow);
            g.drawLine(this.joint.getBodyA().getPosition().x * s, this.joint.getBodyA().getPosition().y * s, this.joint.getBodyB().getPosition().x * s, this.joint.getBodyB().getPosition().y * s);
        }
    }

    protected void doOnOutOfBounds(GameWorld world, float distanceOutOfBounds) {
        if (distanceOutOfBounds - 20.0f > 0.0f) {
            world.getEntities().remove(this);
        }
    }

    public void laserDamage(GameWorld world, Moon moon, float x, float y) {
    }
}

