/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.GravityEntity;
import game.world.GameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class Planet
extends GravityEntity {
    private static final float MAX_HEALTH = 5.0f;
    private static final float HEALTH_REGEN = 0.1f;
    protected float health;

    public Planet(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "planet";
        this.health = 5.0f;
    }

    public boolean applyDamage(float dmg, GameWorld world) {
        this.health -= dmg;
        if (this.health <= 0.0f) {
            this.destroy(world);
            world.getEntities().remove(this);
            return true;
        }
        return false;
    }

    public void debug(Graphics g, GameWorld world, GameContainer container) {
        super.debug(g, world, container);
        g.setColor(Color.red);
        g.drawString(String.valueOf(this.health), 0.0f, 0.0f);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.health > 0.0f) {
            this.health = Math.min(5.0f, this.health + 0.1f * (float)dt / 1000.0f);
        }
    }

    public float getHealthPercentage() {
        return this.health / 5.0f * 100.0f;
    }
}

