/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.entities.PhysicsEntity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;

public class PlanetSpawner
extends Entity {
    private int tick;
    private int tickStep;
    private int spawnPerTick;
    private float spawnForce;

    public PlanetSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setTickStep(5000);
        this.setSpawnPerTick(5);
        this.spawnForce = 150.0f;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.tick += dt;
        if (this.tick > this.tickStep) {
            this.tick = 0;
            this.spawn(world);
        }
    }

    public void setSpawnPerTick(int spawnPerTick) {
        this.spawnPerTick = spawnPerTick;
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    private void spawn(GameWorld world) {
        float arenaRadius = world.getEntities().getOne(ArenaBounds.class).getArenaRadius() + 20.0f;
        float meteorDirectorRadius = arenaRadius * 0.5f;
        Vec2 spawnPosition = new Vec2();
        Vec2 planetDirection = new Vec2();
        for (int i = 0; i < this.spawnPerTick; ++i) {
            spawnPosition.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            spawnPosition.normalize();
            spawnPosition = spawnPosition.mul(arenaRadius);
            planetDirection.x = world.getRandom().nextFloat() * 2.0f - 1.0f;
            planetDirection.y = world.getRandom().nextFloat() * 2.0f - 1.0f;
            planetDirection.normalize();
            planetDirection = planetDirection.mul(meteorDirectorRadius);
            Vec2 forceDir = new Vec2(planetDirection.x - spawnPosition.x, planetDirection.y - spawnPosition.y);
            forceDir.normalize();
            forceDir = forceDir.mul((world.getRandom().nextFloat() + 0.5f) * this.spawnForce);
            int j = world.getRandom().nextInt(3);
            PhysicsEntity planet = j == 0 ? (PhysicsEntity)world.getLoader().create("redplanet") : (j == 1 ? (PhysicsEntity)world.getLoader().create("greenplanet") : (PhysicsEntity)world.getLoader().create("planet"));
            planet.setPos(spawnPosition.x * 100.0f, spawnPosition.y * 100.0f);
            world.getEntities().add(planet);
            planet.getBody().setTransform(spawnPosition, planet.getBody().getAngle());
            planet.body.applyTorque(world.getRandom().nextFloat() - 0.5f);
            planet.body.applyForce(forceDir, spawnPosition);
            PhysicsEntity moon = (PhysicsEntity)world.getLoader().create("moon");
            moon.setPos((spawnPosition.x + 1.0f) * 100.0f, spawnPosition.y * 100.0f);
            world.getEntities().add(moon);
            moon.createOrbit(world, planet, 0.8f, 0.5f);
        }
    }
}

