/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Planet;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class PlayerPlanet
extends Planet {
    private static final float DEFAULT_MOVE_ACCELERATION = 5.0f;
    private static final float OOB_SPRING_CONSTANT = -0.006f;
    private ParticleSystem lineParticles = new ParticleSystem("/assets/graphics/default_particle.png", 40);
    private ConfigurableEmitter lineEmitter;
    private boolean destroyed;

    public PlayerPlanet(EntityDescriptor descriptor) {
        super(descriptor);
        this.lineEmitter = descriptor.particleEmitters.get("line_emitter").duplicate();
        this.lineParticles.addEmitter(this.lineEmitter);
        this.destroyed = false;
        this.transformedRendering = false;
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        Input input = container.getInput();
        Vector2f move = new Vector2f();
        if (input.isKeyDown(17) || input.isKeyDown(200)) {
            move.y = -1.0f;
        } else if (input.isKeyDown(31) || input.isKeyDown(208)) {
            move.y = 1.0f;
        }
        if (input.isKeyDown(30) || input.isKeyDown(203)) {
            move.x = -1.0f;
        } else if (input.isKeyDown(32) || input.isKeyDown(205)) {
            move.x = 1.0f;
        }
        move.normalise();
        move.scale(5.0f * this.body.getMass());
        this.body.applyForce(new Vec2(move.x, move.y), this.body.getWorldCenter());
        Vec2 bodyPos = this.body.getWorldCenter().mul(100.0f);
        this.lineEmitter.setPosition(bodyPos.x, bodyPos.y);
        this.lineParticles.update(dt);
    }

    public void destroy(GameWorld world) {
        this.destroyed = true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        this.lineParticles.render();
        this.applyTransform(g);
        super.render(g, world, container);
        this.applyInverseTransform(g);
    }

    public void renderPlanet(Graphics g, GameWorld world, GameContainer container) {
        super.render(g, world, container);
    }

    protected void doOnOutOfBounds(GameWorld world, float distanceOutOfBounds) {
        float force = -0.006f * distanceOutOfBounds;
        Vec2 bodyPos = this.body.getWorldCenter();
        this.body.applyForce(new Vec2(bodyPos.x * force, bodyPos.y * force), bodyPos);
    }

    public boolean isDestroyed() {
        boolean ret = this.destroyed;
        this.destroyed = false;
        return ret;
    }

    public boolean applyDamage(float dmg, GameWorld world) {
        this.health -= dmg;
        if (this.health <= 0.0f) {
            this.destroy(world);
            return true;
        }
        return false;
    }
}

