/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.PhysicsEntity;
import game.entities.Sun;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jbox2d.common.Vec2;
import org.newdawn.slick.GameContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpacePopulatorEntity
extends Entity {
    private static final float ASTEROID_FIELD_EXTENT = 2.5f;
    private static final float SPACE_CHUNK_SIZE = 40.0f;
    private static final float SPACE_GENERATION_RANGE = 40.0f;
    private static final float SPACE_DESPAWN_RANGE = 80.0f;
    private HashMap<Area, List<Entity>> populatedAreas = new HashMap();

    public SpacePopulatorEntity(EntityDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        Sun playerSun = world.getEntities().getOne(Sun.class);
        Vec2 sunPos = playerSun.getBody().getPosition();
        Iterator<Area> it = this.populatedAreas.keySet().iterator();
        Vec2 cp = new Vec2();
        while (it.hasNext()) {
            Area a = it.next();
            cp.x = a.getCenterX();
            cp.y = a.getCenterY();
            if (!(sunPos.sub(cp).length() > 80.0f)) continue;
            List<Entity> entities = this.populatedAreas.get(a);
            for (Entity e : entities) {
                if (e.getBody() != null && !a.contains(e.getBody().getPosition())) {
                    Area n = this.getArea(e.getBody().getPosition());
                    if (this.populatedAreas.containsKey(n)) {
                        this.populatedAreas.get(n).add(e);
                        continue;
                    }
                    world.getEntities().remove(e);
                    continue;
                }
                world.getEntities().remove(e);
            }
            it.remove();
        }
        for (Area a : this.getNearbyAreas(sunPos)) {
            if (this.populatedAreas.containsKey(a)) continue;
            this.populatedAreas.put(a, this.populate(world, a));
        }
    }

    private List<Entity> populate(GameWorld world, Area a) {
        Vec2[] points;
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Random r = world.getRandom();
        block6: for (Vec2 point : points = a.generateRandomPoints(r, r.nextInt(5) + 5)) {
            if (!(point.length() > 5.0f)) continue;
            int type = r.nextInt(9);
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int count = r.nextInt(9) + 9;
                    for (int i = 0; i < count; ++i) {
                        float x = (r.nextFloat() * 2.0f - 1.0f) * 2.5f;
                        float y = (r.nextFloat() * 2.0f - 1.0f) * 2.5f;
                        Entity meteorite = world.getLoader().create(r.nextBoolean() ? "meteorite" : "meteoriteBig");
                        meteorite.setPos(point.x * 100.0f, point.y * 100.0f);
                        world.getEntities().add(meteorite);
                        meteorite.getBody().setTransform(new Vec2(point.x + x, point.y + y), r.nextFloat() * 360.0f);
                        meteorite.getBody().setAwake(false);
                        ret.add(meteorite);
                    }
                    continue block6;
                }
                case 5: {
                    Entity sun = world.getLoader().create("enemysun");
                    sun.setPos(point.x * 100.0f, point.y * 100.0f);
                    world.getEntities().add(sun);
                    continue block6;
                }
                case 6: {
                    PhysicsEntity planet = (PhysicsEntity)world.getLoader().create("planet");
                    planet.setPos(point.x * 100.0f, point.y * 100.0f);
                    world.getEntities().add(planet);
                    PhysicsEntity moon = (PhysicsEntity)world.getLoader().create("moon");
                    moon.setPos((point.x + 1.0f) * 100.0f, point.y * 100.0f);
                    world.getEntities().add(moon);
                    moon.createOrbit(world, planet, 0.8f, 0.5f);
                    continue block6;
                }
                case 7: {
                    PhysicsEntity pup = (PhysicsEntity)world.getLoader().create(r.nextBoolean() ? "redplanet" : "greenplanet");
                    pup.setPos(point.x * 100.0f, point.y * 100.0f);
                    world.getEntities().add(pup);
                    int moonCount = r.nextInt(3) + 1;
                    for (int i = 0; i < moonCount; ++i) {
                        PhysicsEntity moon = (PhysicsEntity)world.getLoader().create("moon");
                        moon.setPos((point.x + 1.0f + 0.4f * (float)i) * 100.0f, point.y * 100.0f);
                        world.getEntities().add(moon);
                        moon.createOrbit(world, pup, 0.8f + 0.4f * (float)i, 0.5f + 0.4f * (float)i);
                    }
                    continue block6;
                }
            }
        }
        return ret;
    }

    private List<Area> getNearbyAreas(Vec2 pos) {
        int fromX = (int)Math.floor((pos.x - 40.0f) / 40.0f);
        int toX = (int)Math.floor((pos.x + 40.0f) / 40.0f);
        int fromY = (int)Math.floor((pos.y - 40.0f) / 40.0f);
        int toY = (int)Math.floor((pos.y + 40.0f) / 40.0f);
        ArrayList<Area> areas = new ArrayList<Area>();
        for (int i = fromX; i <= toX; ++i) {
            for (int j = fromY; j <= toY; ++j) {
                areas.add(new Area(i, j));
            }
        }
        return areas;
    }

    private Area getArea(Vec2 pos) {
        int x = (int)Math.floor(pos.x / 40.0f);
        int y = (int)Math.floor(pos.y / 40.0f);
        return new Area(x, y);
    }

    private static class Area {
        public final int x;
        public final int y;

        public Area(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean contains(Vec2 p) {
            return p.x >= this.getMinX() && p.x <= this.getMaxX() && p.y >= this.getMinY() && p.y <= this.getMaxY();
        }

        public float getMaxX() {
            return (float)this.x * 40.0f + 40.0f;
        }

        public float getMaxY() {
            return (float)this.y * 40.0f + 40.0f;
        }

        public float getMinX() {
            return (float)this.x * 40.0f;
        }

        public float getMinY() {
            return (float)this.y * 40.0f;
        }

        public float getCenterX() {
            return (float)this.x * 40.0f + 20.0f;
        }

        public float getCenterY() {
            return (float)this.y * 40.0f + 20.0f;
        }

        public float getWidth() {
            return 40.0f;
        }

        public float getHeight() {
            return 40.0f;
        }

        public Vec2[] generateRandomPoints(Random r, int n) {
            Vec2[] points = new Vec2[n];
            for (int i = 0; i < n; ++i) {
                points[i] = new Vec2(this.getMinX() + this.getWidth() * r.nextFloat(), this.getMinY() + this.getHeight() * r.nextFloat());
            }
            return points;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Area) {
                Area a = (Area)obj;
                return this.x == a.x && this.y == a.y;
            }
            return false;
        }

        public int hashCode() {
            return Integer.valueOf(this.x).hashCode() + Integer.valueOf(this.y).hashCode() * 1337;
        }
    }
}

