/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.GravityEntity;
import game.world.GameWorld;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class Sun
extends GravityEntity {
    private static final float DEFAULT_ROTATAION = 0.0f;
    private float[] rotation = new float[]{0.0f, 0.0f};
    private Body anchorBody;
    private ParticleSystem collisionParticles;
    private ConfigurableEmitter collisionParticleEmitter;

    public Sun(EntityDescriptor descriptor) {
        super(descriptor);
        this.collisionParticleEmitter = descriptor.particleEmitters.get("suncollision_emitter").duplicate();
    }

    public void init(GameWorld world) {
        super.init(world);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.STATIC;
        bodyDef.position = this.body.getPosition();
        this.anchorBody = world.getPhysicsWorld().createBody(bodyDef);
        DistanceJointDef def = new DistanceJointDef();
        def.initialize(this.body, this.anchorBody, this.body.getPosition(), this.anchorBody.getPosition());
        def.length = 0.0f;
        def.dampingRatio = 0.9f;
        world.getPhysicsWorld().createJoint(def);
        this.collisionParticles = new ParticleSystem("/assets/graphics/default_particle.png", 50);
        this.collisionParticles.setRemoveCompletedEmitters(true);
    }

    public void destroy(GameWorld world) {
        super.destroy(world);
        if (this.anchorBody != null) {
            world.requestBodyDestruction(this.anchorBody);
            this.anchorBody = null;
        }
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.rotation[0] = this.rotation[0] + (float)dt / 170.0f;
        this.rotation[1] = this.rotation[1] - (float)dt / 110.0f;
        this.collisionParticles.update(dt);
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        g.pushTransform();
        Animation animation = (Animation)this.animations.get("sun_glow");
        if (animation != null) {
            g.pushTransform();
            g.rotate(0.0f, 0.0f, this.getRotation(0));
            g.drawAnimation(animation, -animation.getWidth() / 2, -animation.getHeight() / 2);
            g.popTransform();
        }
        if ((animation = (Animation)this.animations.get("sun2")) != null) {
            g.pushTransform();
            g.rotate(0.0f, 0.0f, this.getRotation(0));
            g.drawAnimation(animation, -animation.getWidth() / 2, -animation.getHeight() / 2);
            g.popTransform();
        }
        this.collisionParticles.render();
        animation = (Animation)this.animations.get("sun1");
        if (animation != null) {
            g.pushTransform();
            g.rotate(0.0f, 0.0f, this.getRotation(1));
            g.drawAnimation(animation, -animation.getWidth() / 2, -animation.getHeight() / 2);
            g.popTransform();
        }
        g.popTransform();
    }

    public void shoot(GameWorld world, Vec2 direction, float initialSpeed) {
        Vec2 sunPos = this.body.getPosition();
        Entity flare = world.getLoader().create("flare");
        Vec2 velocity = direction.mul(initialSpeed);
        float distance = this.body.getFixtureList().getShape().m_radius + 0.2f;
        Vec2 spawnPoint = new Vec2(sunPos.x + distance * direction.x, sunPos.y + distance * direction.y);
        flare.setPos(spawnPoint.x * 100.0f, spawnPoint.y * 100.0f);
        world.getEntities().add(flare);
        flare.getBody().setLinearVelocity(velocity);
    }

    private float getRotation(int i) {
        if (i > 1) {
            return 0.0f;
        }
        return this.rotation[i];
    }

    public void addCollisionParticles(Vector2f collisionPoint) {
        Vector2f particleDirection = new Vector2f(collisionPoint.x - this.getPos().x, collisionPoint.y - this.getPos().y);
        ConfigurableEmitter newCollisionParticleEmitter = this.collisionParticleEmitter.duplicate();
        newCollisionParticleEmitter.setPosition(collisionPoint.x, collisionPoint.y);
        ConfigurableEmitter.SimpleValue val = (ConfigurableEmitter.SimpleValue)newCollisionParticleEmitter.angularOffset;
        val.setValue((float)particleDirection.getTheta());
        newCollisionParticleEmitter.angularOffset = val;
        this.collisionParticles.addEmitter(newCollisionParticleEmitter);
    }
}

