/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;

public class TutorialEntity
extends Entity {
    private State state = State.introduction;
    private Rectangle rectangle = new Rectangle(this.propertyMap.getFloat("x"), this.propertyMap.getFloat("y"), this.propertyMap.getFloat("width"), this.propertyMap.getFloat("height"));
    private String introductionText;
    private String[] stepTexts;
    private int currentStep;
    private Color lineColor;
    private Color fillColor;
    private Color textColor;
    private int padding;
    private Animation icon;
    private boolean ping;

    public TutorialEntity(EntityDescriptor descriptor) {
        super(descriptor);
        float[] lineArray = this.propertyMap.getFloatArray("linecolor", 1.0f, 1.0f, 1.0f, 1.0f);
        float[] fillArray = this.propertyMap.getFloatArray("fillcolor", 1.0f, 1.0f, 1.0f, 1.0f);
        float[] textArray = this.propertyMap.getFloatArray("textcolor", 0.0f, 0.0f, 0.0f, 1.0f);
        this.lineColor = new Color(lineArray[0], lineArray[1], lineArray[2], lineArray[3]);
        this.fillColor = new Color(fillArray[0], fillArray[1], fillArray[2], fillArray[3]);
        this.textColor = new Color(textArray[0], textArray[1], textArray[2], textArray[3]);
        this.introductionText = this.propertyMap.get("introduction", "Introduction");
        int steps = this.propertyMap.getInt("steps", 0);
        this.stepTexts = new String[steps];
        for (int i = 0; i < steps; ++i) {
            this.stepTexts[i] = this.propertyMap.get("step" + (i + 1), "Step " + (i + 1));
        }
        this.padding = this.propertyMap.getInt("padding", 10);
        this.currentStep = 0;
        this.icon = this.animations.get("icon", null);
        this.ping = descriptor.sounds.contains("ping");
    }

    public boolean preRender(Graphics g, GameWorld world, GameContainer container) {
        if (this.state == State.disabled) {
            return false;
        }
        world.getCamera().applyInverseTransform(g, container);
        return true;
    }

    public void render(Graphics g, GameWorld world, GameContainer container) {
        g.setColor(this.fillColor);
        g.fill(this.rectangle);
        g.setColor(this.lineColor);
        g.draw(this.rectangle);
        float xright = this.rectangle.getMinX() + (float)this.padding;
        if (this.icon != null) {
            this.icon.draw(this.rectangle.getMinX() + (float)this.padding, this.rectangle.getCenterY() - (float)this.icon.getHeight() / 2.0f);
            xright += (float)(this.icon.getWidth() + this.padding);
        }
        float ytop = this.rectangle.getMinY() + (float)this.padding;
        String string = this.state == State.introduction ? this.introductionText : this.stepTexts[this.currentStep];
        g.drawString(string, xright, ytop);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        switch (this.state) {
            case introduction: {
                if (container.getInput().isKeyPressed(28)) {
                    this.state = State.tutorial;
                    if (!this.ping) break;
                    this.playAudio("ping", 0.0f);
                    break;
                }
                if (!container.getInput().isKeyPressed(14)) break;
                this.state = State.disabled;
                if (!this.ping) break;
                this.playAudio("ping", 0.0f);
                break;
            }
            case tutorial: {
                if (container.getInput().isKeyPressed(28)) {
                    ++this.currentStep;
                    if (this.currentStep == this.stepTexts.length) {
                        this.state = State.disabled;
                    }
                    if (!this.ping) break;
                    this.playAudio("ping", 0.0f);
                    break;
                }
                if (!container.getInput().isKeyPressed(14)) break;
                if (this.currentStep == 0) {
                    this.state = State.introduction;
                } else {
                    --this.currentStep;
                }
                if (!this.ping) break;
                this.playAudio("ping", 0.0f);
            }
        }
    }

    public void postRender(Graphics g, GameWorld world, GameContainer container) {
        world.getCamera().applyTransform(g, container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        introduction,
        tutorial,
        disabled;

    }
}

