/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.ArenaBounds;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.GameContainer;

public class WaveSpawner
extends Entity {
    private int waveNbr = 1;
    private int timeSpentInWave;
    private int waveLength;

    public WaveSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.setWaveLength(Integer.MAX_VALUE);
    }

    private void setWaveLength(int newWaveLength) {
        this.waveLength = newWaveLength;
    }

    public void advanceWave(GameWorld world) {
        ++this.waveNbr;
        this.timeSpentInWave = 0;
        world.getEntities().getOne(ArenaBounds.class).decreaseRadius(-1.0f);
        this.setWaveLength(20000);
    }

    public void update(int dt, GameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.timeSpentInWave += dt;
        if (this.timeSpentInWave >= this.waveLength) {
            this.advanceWave(world);
        }
    }
}

