/*
 * Decompiled with CFR 0.152.
 */
package game.map;

import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.util.ImageUtil;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;

public class BackgroundRenderer {
    private GameCamera camera;
    private Image starFieldImage;
    private Image backgroundPatternImage;
    private float screenWidth;
    private float screenHeight;

    public BackgroundRenderer(GameCamera camera) {
        this.camera = camera;
        try {
            this.starFieldImage = ImageUtil.load("/assets/graphics/starfield.png");
            this.backgroundPatternImage = ImageUtil.load("/assets/graphics/bkg_pattern.png");
        }
        catch (SlickException e) {
            System.out.println("Couldn't load background images");
        }
    }

    public void update() {
        BoundingBox bbox = this.camera.getScreenBounds();
        this.screenWidth = bbox.getWidth();
        this.screenHeight = bbox.getHeight();
    }

    public void render(Graphics g, GameContainer container) {
        this.drawLayer(g, this.starFieldImage, (float)this.starFieldImage.getWidth() * 1.2f, (float)this.starFieldImage.getHeight() * 1.2f, 0.1f);
        this.drawLayer(g, this.starFieldImage, this.starFieldImage.getWidth(), this.starFieldImage.getHeight(), 0.4f);
        this.drawLayer(g, this.backgroundPatternImage, this.backgroundPatternImage.getWidth(), this.backgroundPatternImage.getHeight(), 1.0f);
    }

    private void drawLayer(Graphics g, Image image, float imageWidth, float imageHeight, float parallaxFactor) {
        int quadVertTiles = (int)Math.ceil(0.5 * (double)this.screenHeight / (double)imageHeight);
        int quadHorTiles = (int)Math.ceil(0.5 * (double)this.screenWidth / (double)imageWidth);
        int quadWidth = (int)((float)quadHorTiles * imageWidth);
        int quadHeight = (int)((float)quadVertTiles * imageHeight);
        Vector2f imageCenter = this.camera.getScreenPos();
        float renderXStart = imageCenter.x - (float)quadWidth - parallaxFactor * imageCenter.x % imageWidth - imageWidth;
        float renderY = imageCenter.y - (float)quadHeight - parallaxFactor * imageCenter.y % imageHeight - imageHeight;
        for (int y = -1; y < quadVertTiles * 2 + 1; ++y) {
            float renderX = renderXStart;
            for (int x = -1; x < quadHorTiles * 2 + 1; ++x) {
                g.drawImage(image, renderX, renderY);
                renderX += imageWidth;
            }
            renderY += imageHeight;
        }
    }
}

