/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.CollisionManager;
import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.loader.EntityLoader;
import game.engine.util.ObjectListener;
import game.engine.util.ObjectManager;
import game.entities.CollisionSoundEntity;
import game.entities.Entity;
import game.entities.GravityEntity;
import game.entities.PhysicsEntity;
import game.map.BackgroundRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.World;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameWorld {
    public static final float PHYSICS_SCALE = 100.0f;
    private static final int PHYSICS_STEP_TIME = 16;
    public static final float G = (float)(6.7 * Math.pow(10.0, 0.0));
    private Random random = new Random();
    private EntityLoader loader;
    private ObjectManager<Entity> objects;
    private GameCamera camera;
    private World world;
    private ArrayList<Body> destroyedBodies;
    private int physicsTime;
    private boolean debug;
    private BackgroundRenderer bgr;
    private CollisionManager collisions;
    private CollisionSoundEntity soundPlayer;

    public GameWorld(EntityLoader loader) {
        this.loader = loader;
        this.camera = new GameCamera();
        this.objects = new ObjectManager<Entity>(Entity.class);
        this.world = new World(new Vec2(0.0f, 0.0f), false);
        this.destroyedBodies = new ArrayList();
        this.collisions = new CollisionManager(this);
        this.world.setContactListener(this.collisions);
        this.bgr = new BackgroundRenderer(this.camera);
        this.debug = false;
        this.objects.addListener(new ObjectListener<Entity>(){

            @Override
            public void onAdd(Entity object) {
                object.init(GameWorld.this);
            }

            @Override
            public void onRemove(Entity object) {
                object.destroy(GameWorld.this);
            }
        });
    }

    public Random getRandom() {
        return this.random;
    }

    public EntityLoader getLoader() {
        return this.loader;
    }

    public ObjectManager<Entity> getEntities() {
        return this.objects;
    }

    public World getPhysicsWorld() {
        return this.world;
    }

    public CollisionManager getCollisionManager() {
        return this.collisions;
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public void update(int dt, GameContainer container) {
        if (container.getInput().isKeyPressed(88)) {
            this.debug = !this.debug;
        }
        this.physicsTime += dt;
        while (this.physicsTime >= 16) {
            this.applyGravity();
            this.runPhysicsSimulation();
            for (Body destroyed : this.destroyedBodies) {
                this.world.destroyBody(destroyed);
            }
            this.destroyedBodies.clear();
            for (Entity o : this.objects.get()) {
                o.update(16, this, container);
            }
            this.camera.update(this, 16);
            this.physicsTime -= 16;
            this.bgr.update();
        }
    }

    private void runPhysicsSimulation() {
        this.world.step(0.016f, 8, 3);
    }

    private void applyGravity() {
        Class<GravityEntity> gravityEntities = this.objects.get((Entity)((Object)GravityEntity.class));
        Class<PhysicsEntity> physicsEntities = this.objects.get((Entity)((Object)PhysicsEntity.class));
        Iterator i$ = gravityEntities.iterator();
        while (i$.hasNext()) {
            GravityEntity gravityEntity = (GravityEntity)i$.next();
            GravityEntity a = gravityEntity;
            Body ba = a.getBody();
            if (ba == null) continue;
            Iterator i$2 = physicsEntities.iterator();
            while (i$2.hasNext()) {
                PhysicsEntity physicsEntity = (PhysicsEntity)i$2.next();
                PhysicsEntity b = physicsEntity;
                if (a.equals(b)) continue;
                Body bb = b.getBody();
                if (ba == null || bb == null) continue;
                this.applyGravityBetweenBodies(ba, bb);
            }
        }
    }

    private void applyGravityBetweenBodies(Body ba, Body bb) {
        Vec2 direction = ba.getPosition().sub(bb.getPosition());
        float r2 = direction.lengthSquared();
        direction.normalize();
        if (r2 > 1.0E-4f) {
            float force = G * ba.getMass() * bb.getMass() / r2;
            Vec2 directionalForce = direction.mul(force);
            Vec2 body1NormV = ba.getLinearVelocity().clone();
            body1NormV.normalize();
            Vec2 body2NormV = bb.getLinearVelocity().clone();
            body2NormV.normalize();
            bb.applyForce(directionalForce, bb.getWorldCenter());
        }
    }

    public void render(Graphics g, GameContainer container) {
        g.pushTransform();
        this.camera.applyTransform(g, container);
        this.bgr.render(g, container);
        List<Entity> objs = this.objects.get();
        Collections.sort(objs, new RenderComparator());
        for (Entity o : objs) {
            g.pushTransform();
            if (o.preRender(g, this, container)) {
                o.render(g, this, container);
                o.postRender(g, this, container);
            }
            g.popTransform();
        }
        if (this.debug) {
            for (Entity o : objs) {
                if (!(o.getPos().distance(this.camera.getScreenPos()) < this.camera.getScreenBounds().getWidth())) continue;
                o.debug(g, this, container);
            }
        }
        g.popTransform();
        if (this.debug) {
            g.pushTransform();
            g.translate((float)container.getWidth() - 200.0f, 0.0f);
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.8f));
            g.fillRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.black);
            g.drawRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.white);
            g.drawString("Debug overlay", 0.0f, 0.0f);
            g.translate(0.0f, g.getFont().getLineHeight());
            g.scale(0.75f, 0.75f);
            StringBuilder sb = new StringBuilder();
            sb.append("Camera bounds:\n");
            GameCamera cam = this.getCamera();
            BoundingBox box = cam.getScreenBounds();
            Vector2f pos = cam.getScreenPos();
            sb.append(String.format("   (%6.3f,%6.3f)\n   (%6.3f,%6.3f)\n", Float.valueOf(box.getMinX(pos) / 100.0f), Float.valueOf(box.getMinY(pos) / 100.0f), Float.valueOf(box.getMaxX(pos) / 100.0f), Float.valueOf(box.getMaxY(pos) / 100.0f)));
            sb.append(String.format("Camera scale: %6.3f\n", Float.valueOf(cam.getScale())));
            sb.append(String.format("Entity count: %d\n", this.objects.size()));
            sb.append(String.format("Body count: %d\n", this.world.getBodyCount()));
            g.drawString(sb.toString(), 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public void requestBodyDestruction(Body body) {
        this.destroyedBodies.add(body);
    }

    public void setSoundPlayer(CollisionSoundEntity soundPlayer) {
        this.soundPlayer = soundPlayer;
    }

    public void collisionSound(float dist) {
        if (this.soundPlayer != null) {
            Random rand = new Random();
            int i = rand.nextInt(2) + 1;
            this.soundPlayer.playAudio("collision" + i, dist);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenderComparator
    implements Comparator<Entity> {
        private RenderComparator() {
        }

        @Override
        public int compare(Entity a, Entity b) {
            return a.compareRenderOrder(b);
        }
    }
}

