/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.LineJointDef;
import org.jbox2d.pooling.IWorldPool;

public class LineJoint
extends Joint {
    public final Vec2 m_localAnchor1 = new Vec2();
    public final Vec2 m_localAnchor2 = new Vec2();
    public final Vec2 m_localXAxis1 = new Vec2();
    private final Vec2 m_localYAxis1 = new Vec2();
    private final Vec2 m_axis = new Vec2();
    private final Vec2 m_perp = new Vec2();
    private float m_s1;
    private float m_s2;
    private float m_a1;
    private float m_a2;
    private final Mat22 m_K = new Mat22();
    private final Vec2 m_impulse = new Vec2();
    private float m_motorMass;
    private float m_motorImpulse;
    private float m_lowerTranslation;
    private float m_upperTranslation;
    private float m_maxMotorForce;
    private float m_motorSpeed;
    private boolean m_enableLimit;
    private boolean m_enableMotor;
    private LimitState m_limitState;

    public LineJoint(IWorldPool argPool, LineJointDef def) {
        super(argPool, def);
        this.m_localAnchor1.set(def.localAnchorA);
        this.m_localAnchor2.set(def.localAnchorB);
        this.m_localXAxis1.set(def.localAxisA);
        Vec2.crossToOut(1.0f, this.m_localXAxis1, this.m_localYAxis1);
        this.m_impulse.setZero();
        this.m_motorMass = 0.0f;
        this.m_motorImpulse = 0.0f;
        this.m_lowerTranslation = def.lowerTranslation;
        this.m_upperTranslation = def.upperTranslation;
        this.m_maxMotorForce = def.maxMotorForce;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
        this.m_limitState = LimitState.INACTIVE;
        this.m_axis.setZero();
        this.m_perp.setZero();
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        Vec2 temp = this.pool.popVec2();
        temp.set(this.m_perp).mulLocal(this.m_impulse.x);
        argOut.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.y).addLocal(temp).mulLocal(inv_dt);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return 0.0f;
    }

    public float getJointTranslation() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        b1.getWorldPointToOut(this.m_localAnchor1, p1);
        b2.getWorldPointToOut(this.m_localAnchor1, p2);
        p2.subLocal(p1);
        b1.getWorldVectorToOut(this.m_localXAxis1, axis);
        float translation = Vec2.dot(p2, axis);
        this.pool.pushVec2(3);
        return translation;
    }

    public float getJointSpeed() {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, r1, r1);
        Mat22.mulToOut(b2.getTransform().R, r2, r2);
        p1.set(b1.m_sweep.c).addLocal(r1);
        p2.set(b2.m_sweep.c).addLocal(r2);
        p2.subLocal(p1);
        Vec2 axis = this.pool.popVec2();
        b1.getWorldPointToOut(this.m_localXAxis1, axis);
        Vec2 v1 = b1.m_linearVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        float w2 = b2.m_angularVelocity;
        Vec2 temp1 = this.pool.popVec2();
        Vec2 temp2 = this.pool.popVec2();
        Vec2.crossToOut(w1, r1, temp1);
        Vec2.crossToOut(w2, r2, temp2);
        temp2.addLocal(v2).subLocal(v1).subLocal(temp1);
        float s2 = Vec2.dot(axis, temp2);
        Vec2.crossToOut(w1, axis, temp1);
        float speed = Vec2.dot(p2, temp1) + s2;
        this.pool.pushVec2(7);
        return speed;
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void EnableLimit(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_lowerTranslation = lower;
        this.m_upperTranslation = upper;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void EnableMotor(boolean flag) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float force) {
        this.m_bodyA.setAwake(true);
        this.m_bodyB.setAwake(true);
        this.m_maxMotorForce = force;
    }

    public float getMaxMotorForce() {
        return this.m_maxMotorForce;
    }

    public float getMotorForce() {
        return this.m_motorImpulse;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        this.m_localCenterA.set(b1.getLocalCenter());
        this.m_localCenterB.set(b2.getLocalCenter());
        Transform xf1 = b1.getTransform();
        Transform xf2 = b2.getTransform();
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        r2.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(xf1.R, r1, r1);
        Mat22.mulToOut(xf2.R, r2, r2);
        Vec2 d = this.pool.popVec2();
        d.set(b2.m_sweep.c).addLocal(r2).subLocal(b1.m_sweep.c).subLocal(r1);
        this.m_invMassA = b1.m_invMass;
        this.m_invIA = b1.m_invI;
        this.m_invMassB = b2.m_invMass;
        this.m_invIB = b2.m_invI;
        Mat22.mulToOut(xf1.R, this.m_localXAxis1, this.m_axis);
        temp.set(d).addLocal(r1);
        this.m_a1 = Vec2.cross(temp, this.m_axis);
        this.m_a2 = Vec2.cross(r2, this.m_axis);
        this.m_motorMass = this.m_invMassA + this.m_invMassB + this.m_invIA * this.m_a1 * this.m_a1 + this.m_invIB * this.m_a2 * this.m_a2;
        this.m_motorMass = this.m_motorMass > 1.1920929E-7f ? 1.0f / this.m_motorMass : 0.0f;
        Mat22.mulToOut(xf1.R, this.m_localYAxis1, this.m_perp);
        temp.set(d).addLocal(r1);
        this.m_s1 = Vec2.cross(temp, this.m_perp);
        this.m_s2 = Vec2.cross(r2, this.m_perp);
        float m1 = this.m_invMassA;
        float m2 = this.m_invMassB;
        float i1 = this.m_invIA;
        float i2 = this.m_invIB;
        float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
        float k12 = i1 * this.m_s1 * this.m_a1 + i2 * this.m_s2 * this.m_a2;
        float k22 = m1 + m2 + i1 * this.m_a1 * this.m_a1 + i2 * this.m_a2 * this.m_a2;
        this.m_K.col1.set(k11, k12);
        this.m_K.col2.set(k12, k22);
        if (this.m_enableLimit) {
            float jointTranslation = Vec2.dot(this.m_axis, d);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.m_limitState = LimitState.EQUAL;
            } else if (jointTranslation <= this.m_lowerTranslation) {
                if (this.m_limitState != LimitState.AT_LOWER) {
                    this.m_limitState = LimitState.AT_LOWER;
                    this.m_impulse.y = 0.0f;
                }
            } else if (jointTranslation >= this.m_upperTranslation) {
                if (this.m_limitState != LimitState.AT_UPPER) {
                    this.m_limitState = LimitState.AT_UPPER;
                    this.m_impulse.y = 0.0f;
                }
            } else {
                this.m_limitState = LimitState.INACTIVE;
                this.m_impulse.y = 0.0f;
            }
        } else {
            this.m_limitState = LimitState.INACTIVE;
        }
        if (!this.m_enableMotor) {
            this.m_motorImpulse = 0.0f;
        }
        if (step.warmStarting) {
            this.m_impulse.mulLocal(step.dtRatio);
            this.m_motorImpulse *= step.dtRatio;
            Vec2 P = this.pool.popVec2();
            temp.set(this.m_axis).mulLocal(this.m_motorImpulse + this.m_impulse.y);
            P.set(this.m_perp).mulLocal(this.m_impulse.x).addLocal(temp);
            float L1 = this.m_impulse.x * this.m_s1 + (this.m_motorImpulse + this.m_impulse.y) * this.m_a1;
            float L2 = this.m_impulse.x * this.m_s2 + (this.m_motorImpulse + this.m_impulse.y) * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            b1.m_linearVelocity.subLocal(temp);
            b1.m_angularVelocity -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += this.m_invIB * L2;
            this.pool.pushVec2(1);
        } else {
            this.m_impulse.setZero();
            this.m_motorImpulse = 0.0f;
        }
        this.pool.pushVec2(4);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 v1 = b1.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w2 = b2.m_angularVelocity;
        Vec2 temp = this.pool.popVec2();
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL) {
            temp.set(v2).subLocal(v1);
            float Cdot = Vec2.dot(this.m_axis, temp) + this.m_a2 * w2 - this.m_a1 * w1;
            float impulse = this.m_motorMass * (this.m_motorSpeed - Cdot);
            float oldImpulse = this.m_motorImpulse;
            float maxImpulse = step.dt * this.m_maxMotorForce;
            this.m_motorImpulse = MathUtils.clamp(this.m_motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.m_motorImpulse - oldImpulse;
            Vec2 P = this.pool.popVec2();
            P.set(this.m_axis).mulLocal(impulse);
            float L1 = impulse * this.m_a1;
            float L2 = impulse * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(1);
        }
        temp.set(v2).subLocal(v1);
        float Cdot1 = Vec2.dot(this.m_perp, temp) + this.m_s2 * w2 - this.m_s1 * w1;
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE) {
            temp.set(v2).subLocal(v1);
            float Cdot2 = Vec2.dot(this.m_axis, temp) + this.m_a2 * w2 - this.m_a1 * w1;
            Vec2 Cdot = this.pool.popVec2();
            Cdot.set(Cdot1, Cdot2);
            Vec2 f1 = this.pool.popVec2();
            f1.set(this.m_impulse);
            Vec2 df = this.pool.popVec2();
            this.m_K.solveToOut(Cdot.negateLocal(), df);
            this.m_impulse.addLocal(df);
            if (this.m_limitState == LimitState.AT_LOWER) {
                this.m_impulse.y = MathUtils.max(this.m_impulse.y, 0.0f);
            } else if (this.m_limitState == LimitState.AT_UPPER) {
                this.m_impulse.y = MathUtils.min(this.m_impulse.y, 0.0f);
            }
            float b = -Cdot1 - (this.m_impulse.y - f1.y) * this.m_K.col2.x;
            float f2r = this.m_K.col1.x != 0.0f ? b / this.m_K.col1.x + f1.x : f1.x;
            this.m_impulse.x = f2r;
            df.set(this.m_impulse).subLocal(f1);
            Vec2 P = this.pool.popVec2();
            temp.set(this.m_axis).mulLocal(df.y);
            P.set(this.m_perp).mulLocal(df.x).addLocal(temp);
            float L1 = df.x * this.m_s1 + df.y * this.m_a1;
            float L2 = df.x * this.m_s2 + df.y * this.m_a2;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(4);
        } else {
            float df = this.m_K.col1.x != 0.0f ? -Cdot1 / this.m_K.col1.x : 0.0f;
            this.m_impulse.x += df;
            Vec2 P = this.pool.popVec2();
            P.set(this.m_perp).mulLocal(df);
            float L1 = df * this.m_s1;
            float L2 = df * this.m_s2;
            temp.set(P).mulLocal(this.m_invMassA);
            v1.subLocal(temp);
            w1 -= this.m_invIA * L1;
            temp.set(P).mulLocal(this.m_invMassB);
            v2.addLocal(temp);
            w2 += this.m_invIB * L2;
            this.pool.pushVec2(1);
        }
        this.pool.pushVec2(1);
        b1.m_angularVelocity = w1;
        b2.m_angularVelocity = w2;
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        float i1;
        float m2;
        float m1;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 c1 = b1.m_sweep.c;
        float a1 = b1.m_sweep.a;
        Vec2 c2 = b2.m_sweep.c;
        float a2 = b2.m_sweep.a;
        float linearError = 0.0f;
        float angularError = 0.0f;
        boolean active = false;
        float C2 = 0.0f;
        Mat22 R1 = this.pool.popMat22();
        Mat22 R2 = this.pool.popMat22();
        R1.set(a1);
        R2.set(a2);
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2 d = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(this.m_localCenterA);
        r2.set(this.m_localAnchor2).subLocal(this.m_localCenterB);
        Mat22.mulToOut(R1, r1, r1);
        Mat22.mulToOut(R2, r2, r2);
        d.set(c2).addLocal(r2).subLocal(c1).subLocal(r1);
        if (this.m_enableLimit) {
            Mat22.mulToOut(R1, this.m_localXAxis1, this.m_axis);
            temp.set(d).addLocal(r1);
            this.m_a1 = Vec2.cross(temp, this.m_axis);
            this.m_a2 = Vec2.cross(r2, this.m_axis);
            float translation = Vec2.dot(this.m_axis, d);
            if (MathUtils.abs(this.m_upperTranslation - this.m_lowerTranslation) < 2.0f * Settings.linearSlop) {
                C2 = MathUtils.clamp(translation, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                linearError = MathUtils.abs(translation);
                active = true;
            } else if (translation <= this.m_lowerTranslation) {
                C2 = MathUtils.clamp(translation - this.m_lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                linearError = this.m_lowerTranslation - translation;
                active = true;
            } else if (translation >= this.m_upperTranslation) {
                C2 = MathUtils.clamp(translation - this.m_upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                linearError = translation - this.m_upperTranslation;
                active = true;
            }
        }
        Mat22.mulToOut(R1, this.m_localYAxis1, this.m_perp);
        temp.set(d).addLocal(r1);
        this.m_s1 = Vec2.cross(temp, this.m_perp);
        this.m_s2 = Vec2.cross(r2, this.m_perp);
        Vec2 impulse = this.pool.popVec2();
        float C1 = Vec2.dot(this.m_perp, d);
        linearError = MathUtils.max(linearError, MathUtils.abs(C1));
        angularError = 0.0f;
        if (active) {
            m1 = this.m_invMassA;
            m2 = this.m_invMassB;
            i1 = this.m_invIA;
            float i2 = this.m_invIB;
            float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
            float k12 = i1 * this.m_s1 * this.m_a1 + i2 * this.m_s2 * this.m_a2;
            float k22 = m1 + m2 + i1 * this.m_a1 * this.m_a1 + i2 * this.m_a2 * this.m_a2;
            this.m_K.col1.set(k11, k12);
            this.m_K.col2.set(k12, k22);
            Vec2 C = this.pool.popVec2();
            C.x = C1;
            C.y = C2;
            this.m_K.solveToOut(C.negateLocal(), impulse);
            this.pool.pushVec2(1);
        } else {
            m1 = this.m_invMassA;
            m2 = this.m_invMassB;
            i1 = this.m_invIA;
            float i2 = this.m_invIB;
            float k11 = m1 + m2 + i1 * this.m_s1 * this.m_s1 + i2 * this.m_s2 * this.m_s2;
            float impulse1 = k11 != 0.0f ? -C1 / k11 : 0.0f;
            impulse.x = impulse1;
            impulse.y = 0.0f;
        }
        Vec2 P = this.pool.popVec2();
        temp.set(this.m_axis).mulLocal(impulse.y);
        P.set(this.m_perp).mulLocal(impulse.x).add(temp);
        float L1 = impulse.x * this.m_s1 + impulse.y * this.m_a1;
        float L2 = impulse.x * this.m_s2 + impulse.y * this.m_a2;
        temp.set(P).mulLocal(this.m_invMassA);
        c1.subLocal(temp);
        temp.set(P).mulLocal(this.m_invMassB);
        c2.addLocal(temp);
        b1.m_sweep.a = a1 -= this.m_invIA * L1;
        b2.m_sweep.a = a2 += this.m_invIB * L2;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        this.pool.pushVec2(6);
        this.pool.pushMat22(2);
        return linearError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }
}

