/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGame;
import game.LudumDareGameState;
import game.engine.util.ImageUtil;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;

public class LudumDareGameOverState
extends BasicGameState {
    private Image gameOver;
    private int waitTime;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.gameOver = ImageUtil.load("/assets/graphics/Lose_screen.png");
        this.waitTime = 0;
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        Image endScreen = ((LudumDareGame)game).getEndScreen();
        g.drawImage(endScreen, 0.0f, 0.0f);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g.fillRect(0.0f, 0.0f, container.getWidth(), container.getHeight());
        g.scale(2.0f, 2.0f);
        float w = (float)container.getWidth() / 2.0f;
        float h = (float)container.getHeight() / 2.0f;
        g.drawImage(this.gameOver, (w - (float)this.gameOver.getWidth()) / 2.0f, (h - (float)this.gameOver.getHeight()) / 2.0f);
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        if (this.waitTime > 0) {
            this.waitTime -= dt;
        }
        if (this.waitTime <= 0 && (container.getInput().isKeyPressed(28) || container.getInput().isKeyPressed(57) || container.getInput().isMousePressed(0))) {
            game.enterState(LudumDareGameState.game.ordinal(), new FadeOutTransition(Color.black, 500), new FadeInTransition(Color.black, 500));
        }
    }

    public int getID() {
        return LudumDareGameState.gameOver.ordinal();
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.waitTime = 2500;
    }
}

