/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.LudumDareGame;
import game.LudumDareGameState;
import game.engine.loader.EntityLoader;
import game.world.VillainGameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;

public class LudumDareGameplayState
extends BasicGameState {
    private VillainGameWorld world;
    private EntityLoader loader;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.loader = new EntityLoader("/assets/xml");
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.world.render(g, container);
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        this.world.update(dt, container);
        if (this.world.isVictorious()) {
            game.enterState(LudumDareGameState.victory.ordinal(), new FadeOutTransition(Color.black, 500), new FadeInTransition(Color.black, 500));
        }
        if (this.world.isGameOver()) {
            game.enterState(LudumDareGameState.gameOver.ordinal(), new FadeOutTransition(Color.black, 500), new FadeInTransition(Color.black, 500));
        }
    }

    public int getID() {
        return LudumDareGameState.game.ordinal();
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        Image endScreen = new Image(container.getWidth(), container.getHeight());
        Graphics g = endScreen.getGraphics();
        this.render(container, game, g);
        g.flush();
        ((LudumDareGame)game).setEndScreen(endScreen);
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.world = new VillainGameWorld(this.loader);
        this.world.init(container);
    }
}

