/*
 * Decompiled with CFR 0.152.
 */
package game.engine;

import game.engine.BoundingBox;
import game.entities.Entity;
import game.world.VillainGameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class GameCamera {
    private float scale = 1.0f;
    private Entity stalked;
    private BoundingBox screenBounds;
    private Vector2f screenSize;
    private Vector2f screenPos = new Vector2f(0.0f, 0.0f);

    public GameCamera() {
        this.screenSize = new Vector2f(0.0f, 0.0f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public float getScale() {
        return this.scale;
    }

    public void init(int screenWidth, int screenHeight) {
        this.screenPos = new Vector2f(0.0f, 0.0f);
        this.screenSize.set(screenWidth, screenHeight);
        this.updateBounds();
    }

    public void update(VillainGameWorld world, int dt) {
        if (this.stalked != null) {
            Vector2f pos = this.stalked.getPos();
            this.setScale(this.scale);
            this.screenPos.set(pos.x, pos.y);
            this.updateBounds();
        }
    }

    private void updateBounds() {
        this.screenBounds = new BoundingBox(0.0f, 0.0f, this.screenSize.x / this.scale, this.screenSize.y / this.scale);
    }

    public BoundingBox getScreenBounds() {
        if (this.screenBounds == null) {
            return new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.screenBounds;
    }

    public Vector2f getScreenPos() {
        return this.screenPos;
    }

    public void applyTransform(Graphics g, GameContainer container) {
        g.scale(this.scale, this.scale);
    }

    public void applyInverseTransform(Graphics g, GameContainer container) {
        g.scale(1.0f / this.scale, 1.0f / this.scale);
    }

    public Vector2f screenToWorld(float x, float y) {
        float sx = this.getScreenBounds().getMinX(this.getScreenPos());
        float sy = this.getScreenBounds().getMinY(this.getScreenPos());
        return new Vector2f(sx + x / this.scale, sy + y / this.scale);
    }
}

