/*
 * Decompiled with CFR 0.152.
 */
package game.engine.input;

import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.input.MousePositionEvent;
import game.engine.input.MouseScrollEvent;
import java.util.ArrayList;
import java.util.List;
import org.newdawn.slick.Input;
import org.newdawn.slick.MouseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseManager
implements MouseListener {
    private ArrayList<MouseEvent> events;
    private Input input;

    public MouseManager(Input input) {
        this.input = input;
        input.addMouseListener(this);
        this.events = new ArrayList();
    }

    public synchronized List<MouseEvent> takeEvents() {
        ArrayList<MouseEvent> old = this.events;
        old.add(new MousePositionEvent(this.input.getMouseX(), this.input.getMouseY()));
        this.events = new ArrayList();
        return old;
    }

    @Override
    public synchronized void inputEnded() {
    }

    @Override
    public synchronized void inputStarted() {
    }

    @Override
    public synchronized boolean isAcceptingInput() {
        return true;
    }

    @Override
    public synchronized void setInput(Input input) {
    }

    @Override
    public synchronized void mouseClicked(int button, int x, int y, int count) {
        this.events.add(new MouseClickEvent(x, y, button));
    }

    @Override
    public synchronized void mouseDragged(int arg0, int arg1, int arg2, int arg3) {
    }

    @Override
    public synchronized void mouseMoved(int arg0, int arg1, int arg2, int arg3) {
    }

    @Override
    public synchronized void mousePressed(int arg0, int arg1, int arg2) {
    }

    @Override
    public synchronized void mouseReleased(int arg0, int arg1, int arg2) {
    }

    @Override
    public synchronized void mouseWheelMoved(int delta) {
        this.events.add(new MouseScrollEvent(this.input.getMouseX(), this.input.getMouseY(), delta));
    }
}

