/*
 * Decompiled with CFR 0.152.
 */
package game.engine.loader;

import game.engine.loader.AssetEntry;
import game.engine.loader.LoaderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetStore<T>
implements Iterable<AssetEntry<T>> {
    private HashMap<String, T> store = new HashMap();

    protected AssetStore() {
    }

    protected void add(String id, T asset) {
        if (this.store.containsKey(id = id.toLowerCase())) {
            throw new LoaderException("Asset with id " + id + " is already present in asset store.");
        }
        this.store.put(id, asset);
    }

    public T get(String id) {
        return this.store.get(id.toLowerCase());
    }

    public T get(String id, T def) {
        if (this.store.containsKey(id = id.toLowerCase())) {
            return this.store.get(id);
        }
        return def;
    }

    public boolean contains(String id) {
        return this.store.containsKey(id.toLowerCase());
    }

    @Override
    public Iterator<AssetEntry<T>> iterator() {
        final Iterator<Map.Entry<String, T>> it = this.store.entrySet().iterator();
        return new Iterator<AssetEntry<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public AssetEntry<T> next() {
                Map.Entry entry = (Map.Entry)it.next();
                return new AssetEntry((String)entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing assets during runtime is not supported.");
            }
        };
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }
}

