/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Console;
import game.entities.Hero;
import game.entities.SelectionCoordinator;
import game.entities.Traversable;
import game.entities.Traverser;
import game.world.VillainGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class Boss
extends Traverser {
    private static final float MAX_HP = 100.0f;
    private float moveSpeed;
    private State state;
    private Traversable current;
    private float stateTime;
    private float hitPoints;
    private float maxHitPoints;
    private int cash;
    private String name;

    public Boss(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "walk";
        this.moveSpeed = descriptor.properties.getFloat("movespeed", 16.0f);
        this.state = State.idle;
        this.current = null;
        this.stateTime = 0.0f;
        this.hitPoints = this.maxHitPoints = descriptor.properties.getFloat("maxhealth", 100.0f);
        this.cash = descriptor.properties.getInt("startingcash", 100);
        this.name = descriptor.properties.get("name", "Unnamed");
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        MouseClickEvent click;
        super.handleMouseEvent(world, event);
        if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.click && (click = (MouseClickEvent)event).leftClick()) {
            world.getEntities().getOne(SelectionCoordinator.class).setSelection(this);
            click.consume();
        }
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        this.currentState = this.state.animationState;
        if (this.current == null) {
            world.getEntities().remove(this);
        } else {
            this.stateTime += (float)dt / 1000.0f;
            BoundingBox bb = this.getBounds();
            Vector2f zero = new Vector2f(0.0f, 0.0f);
            Vector2f from = new Vector2f(-bb.getCenterX(zero), -bb.getCenterY(zero));
            Vector2f to = new Vector2f(-bb.getCenterX(zero), -bb.getCenterY(zero));
            switch (this.state) {
                case idle: {
                    to.add(this.current.getMidPoint());
                    this.setPos(to);
                    if (this.current.getNextTraversable() == null) break;
                    this.stateTime = 0.0f;
                    this.state = State.exiting;
                    break;
                }
                case entering: {
                    from.add(this.current.getEntryPoint());
                    to.add(this.current.getMidPoint());
                    float distance = from.distance(to);
                    float time = distance / this.moveSpeed;
                    if (this.stateTime >= time) {
                        this.state = this.current.getNextTraversable() == null ? State.idle : State.exiting;
                        this.stateTime -= time;
                        this.current.onFinishedEntering(this);
                        break;
                    }
                    float x = this.stateTime / time;
                    this.setPos((1.0f - x) * from.x + x * to.x, (1.0f - x) * from.y + x * to.y);
                    break;
                }
                case fighting: {
                    to.add(this.current.getMidPoint());
                    to.x += this.getBounds().getWidth() / 2.0f + 2.0f;
                    this.setPos(to);
                    this.stateTime = 0.0f;
                    break;
                }
                case exiting: {
                    from.add(this.current.getMidPoint());
                    to.add(this.current.getExitPoint());
                    float distance = from.distance(to);
                    float time = distance / this.moveSpeed;
                    if (this.stateTime >= time) {
                        this.current.onFinishedExiting(this);
                        this.current = this.current.getNextTraversable();
                        this.state = State.entering;
                        this.stateTime -= time;
                        if (this.current == null) break;
                        this.current.onStartEntering(this);
                        break;
                    }
                    float x = this.stateTime / time;
                    this.setPos((1.0f - x) * from.x + x * to.x, (1.0f - x) * from.y + x * to.y);
                }
            }
        }
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        if (world.getEntities().getOne(SelectionCoordinator.class).getSelection() == this) {
            g.drawAnimation((Animation)this.animations.get("selection"), 0.0f, 0.0f);
        }
    }

    public void teleport(Traversable traversable) {
        if (this.current != null) {
            if (this.state != State.exiting) {
                this.current.onStartExiting(this);
            }
            this.current.onFinishedExiting(this);
        }
        this.current = traversable;
        this.setPos(traversable.getMidPoint());
        this.state = State.idle;
        this.current.onStartEntering(this);
        this.current.onFinishedEntering(this);
    }

    public void endFight(VillainGameWorld world, Hero hero) {
        this.state = State.idle;
        float damage = hero.getBossDMG() * (hero.getHitpoints() / hero.getMaxHitpoints());
        this.hitPoints -= damage;
        if (this.hitPoints <= 0.0f) {
            this.state = State.dead;
            this.hitPoints = 0.0f;
            world.println(Console.MessageColor.WARNING, "You have been slain by %s", hero.getName());
        } else {
            this.playAudio("growl", 0.5f);
            int di = Math.max(1, (int)(100.0f * damage / this.getMaxHitpoints()));
            world.println(Console.MessageColor.HINT, "%s managed to slash you for %d%% of your health before he met his end.", hero.getName(), di);
        }
        hero.slainByBoss(world);
        this.earnCash(hero.getCashWorth());
    }

    public void startFight(VillainGameWorld world, Hero hero) {
        this.state = State.fighting;
        this.playAudio("growl", 0.5f);
    }

    public State getState() {
        return this.state;
    }

    public Traversable getCurrentTraversable() {
        return this.current;
    }

    public String getName() {
        return this.name;
    }

    public int getCash() {
        return this.cash;
    }

    public boolean deductCash(int amount) {
        if (amount > this.cash) {
            return false;
        }
        this.cash -= amount;
        return true;
    }

    public boolean hasCash(int amount) {
        return amount <= this.cash;
    }

    public void earnCash(int amount) {
        this.cash += amount;
    }

    public float getHitpoints() {
        return this.hitPoints;
    }

    public float getMaxHitpoints() {
        return this.maxHitPoints;
    }

    public Animation getPortrait() {
        return (Animation)this.animations.get("portrait");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        idle("idle"),
        entering("walk"),
        fighting("fight"),
        exiting("walk"),
        dead("dead");

        private String animationState;

        private State(String animationState) {
            this.animationState = animationState;
        }
    }
}

