/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Boss;
import game.entities.InformationBox;
import game.entities.Room;
import game.entities.RoomCursor;
import game.entities.UserInterfacePane;
import game.ui.ScrollPane;
import game.ui.UIComponent;
import game.world.VillainGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class BuildMenu
extends UserInterfacePane {
    private static final float SPACING_ENTRY = 6.0f;
    private static final float PADDING_TOP = 18.0f;
    private static final float PADDING_BOTTOM = 5.0f;
    private static final float PADDING_LEFT = 5.0f;
    private static final float BORDER_MARGIN = 2.0f;
    private static final float SCROLL_SPEED = 0.1f;
    private static final float STATS_HEIGHT = 36.0f;
    private String[] roomTypes;
    private RoomCursor currentCursor;
    private BuildOption selectedOption;
    private StatsPanel stats;

    public BuildMenu(EntityDescriptor descriptor) {
        super(descriptor);
        this.roomTypes = descriptor.properties.getArray("roomtypes");
        if (this.roomTypes == null) {
            this.roomTypes = new String[0];
            System.out.println("Warning! No roomtypes specified for build menu " + descriptor.name + ".");
        }
        this.currentCursor = null;
        this.selectedOption = null;
    }

    private void selectOption(VillainGameWorld world, BuildOption option) {
        if (this.currentCursor != null) {
            world.getEntities().remove(this.currentCursor);
        }
        if (world.getBoss().hasCash(option.room.getPrice())) {
            this.currentCursor = (RoomCursor)world.getLoader().create("roomcursor");
            this.currentCursor.setRoom(world.getWorld().createRoom(option.name));
            this.currentCursor.setPlacementRestriction(world.getWorld().getPlacementRestriction());
            world.getEntities().add(this.currentCursor);
            this.selectedOption = option;
            option.room.playAudio("default", 0.5f);
        }
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        float width = this.getBounds().getWidth() - 10.0f;
        float height = this.getBounds().getHeight() - 18.0f - 5.0f - 6.0f - 36.0f;
        ScrollPane scrollPane = new ScrollPane(5.0f, 18.0f, width, height, 0.1f);
        this.getRootPane().addComponent(scrollPane);
        Animation def = (Animation)this.animations.get("buildoptiondefault");
        Animation sel = (Animation)this.animations.get("buildoptionselected");
        float space = (width - (float)def.getWidth()) / 2.0f;
        float y = 3.0f;
        for (int i = 0; i < this.roomTypes.length; ++i) {
            Room room = (Room)world.getLoader().create(this.roomTypes[i]);
            BuildOption option = new BuildOption(space, y, this.roomTypes[i], (Animation)this.animations.get(this.roomTypes[i]), room, def, sel);
            scrollPane.getContainer().addComponent(option);
            y += option.getSize().y + 6.0f;
        }
        this.stats = new StatsPanel(5.0f, 18.0f + height + 6.0f, width, 36.0f);
        this.stats.setBoss(null);
        this.getRootPane().addComponent(this.stats);
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.stats.setBoss(world.getEntities().getOne(Boss.class));
        if (this.currentCursor != null && this.currentCursor.isDestroyed()) {
            this.currentCursor = null;
            this.selectedOption = null;
        }
    }

    private class BuildOption
    extends UIComponent {
        private String name;
        private Animation icon;
        private Room room;
        private Animation def;
        private Animation sel;

        public BuildOption(float x, float y, String name, Animation icon, Room room, Animation def, Animation sel) {
            super(x, y, def.getWidth(), def.getHeight());
            this.name = name;
            this.icon = icon;
            this.room = room;
            this.def = def;
            this.sel = sel;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            if (BuildMenu.this.selectedOption == this && BuildMenu.this.currentCursor != null) {
                g.drawAnimation(this.sel, 0.0f, 0.0f);
            } else {
                g.drawAnimation(this.def, 0.0f, 0.0f);
            }
            g.translate(2.0f, 2.0f);
            g.drawAnimation(this.icon, 0.0f, 0.0f);
            g.translate((float)this.icon.getWidth() + 2.0f, this.getSize().y / 2.0f);
            g.scale(0.5f, 0.5f);
            g.translate(0.0f, -this.getFont().getLineHeight());
            g.setColor(Color.white);
            g.setFont(this.getFont());
            g.drawString(this.room.getName(), 0.0f, 0.0f);
            g.translate(0.0f, this.getFont().getLineHeight());
            g.drawString("Price: " + this.room.getPrice() + " gold", 0.0f, 0.0f);
        }

        public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
            super.handleMouseEvent(world, event);
            if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.click && ((MouseClickEvent)event).leftClick()) {
                BuildMenu.this.selectOption(world, this);
            } else if (event.type() == MouseEvent.Type.position) {
                InformationBox info = world.getEntities().getOne(InformationBox.class);
                if (event.contained() && info.getOverrideRoom() != this.room) {
                    info.overrideRoom(this.room);
                } else if (!event.contained() && info.getOverrideRoom() == this.room) {
                    info.overrideRoom(null);
                }
            }
        }
    }

    private class StatsPanel
    extends UIComponent {
        private Boss boss;

        public StatsPanel(float x, float y, float w, float h) {
            super(x, y, w, h);
            this.boss = null;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            if (this.boss == null) {
                return;
            }
            float dy = this.getFont().getLineHeight();
            float x = 0.0f;
            float y = 0.0f;
            g.setFont(this.getFont());
            Animation a = (Animation)BuildMenu.this.animations.get("health");
            g.drawAnimation(a, x, y);
            g.setColor(Color.white);
            float healthNormalized = this.boss.getHitpoints() / this.boss.getMaxHitpoints();
            int hp = (int)(100.0f * healthNormalized + 0.5f);
            String s = String.format("%d%%", hp);
            int w = this.getFont().getWidth(s);
            int h = this.getFont().getHeight(s);
            g.drawString(s, (float)a.getWidth() + 2.0f, y + (float)(a.getHeight() - h) / 2.0f);
            y += (float)a.getHeight();
            a = (Animation)BuildMenu.this.animations.get("cash");
            g.drawAnimation(a, x, y);
            g.setColor(Color.white);
            s = String.format("%d", this.boss.getCash());
            int w2 = this.getFont().getWidth(s);
            int h2 = this.getFont().getHeight(s);
            g.drawString(s, (float)a.getWidth() + 2.0f, y + (float)(a.getHeight() - h2) / 2.0f);
            y += (float)a.getHeight();
        }

        public void setBoss(Boss boss) {
            this.boss = boss;
        }
    }
}

