/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.VillainGameWorld;
import java.util.LinkedList;
import java.util.Queue;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class Character
extends Entity {
    public Queue<Action> actions = new LinkedList<Action>();

    public Character(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void pushAction(Action action) {
        if (this.actions.isEmpty()) {
            this.actions.add(new NullAction());
        }
        this.actions.add(action);
    }

    public Color getColorFromNormalizedHealth(float hn) {
        if (hn <= 0.25f) {
            return Color.red;
        }
        if (hn <= 0.5f) {
            return Color.orange;
        }
        if (hn <= 0.75f) {
            return Color.yellow;
        }
        return Color.green;
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        float time = (float)dt / 1000.0f;
        while (time > 0.0f && !this.actions.isEmpty()) {
            time = this.actions.peek().update(this, time, world, container);
            if (!(time > 0.0f)) continue;
            this.actions.peek().onExit(world, this);
            this.actions.poll();
            if (this.actions.isEmpty()) continue;
            this.actions.peek().onEnter(world, this);
        }
    }

    public static class NullAction
    implements Action {
        public float update(Character character, float dt, VillainGameWorld world, GameContainer container) {
            return dt;
        }

        public void onEnter(VillainGameWorld world, Character character) {
        }

        public void onExit(VillainGameWorld world, Character character) {
        }
    }

    public static class IdleAction
    implements Action {
        private Vector2f at;
        private float time;

        public IdleAction(Vector2f at) {
            this.at = at;
            this.time = Float.POSITIVE_INFINITY;
        }

        public float update(Character character, float dt, VillainGameWorld world, GameContainer container) {
            this.time -= dt;
            character.setPos(this.at);
            return Math.max(0.0f, -this.time);
        }

        public void onEnter(VillainGameWorld world, Character character) {
        }

        public void onExit(VillainGameWorld world, Character character) {
        }
    }

    public static class MoveAction
    implements Action {
        private Vector2f from;
        private Vector2f to;
        private float time;
        private float totalTime;

        public MoveAction(Vector2f from, Vector2f to, float speed) {
            this.from = from;
            this.to = to;
            this.time = this.totalTime = from.distance(to) / speed;
        }

        public float update(Character character, float dt, VillainGameWorld world, GameContainer container) {
            this.time -= dt;
            float x = this.time / this.totalTime;
            character.setPos((1.0f - x) * this.from.x + x * this.to.x, (1.0f - x) * this.from.y + x * this.to.y);
            return Math.max(0.0f, -this.time);
        }

        public void onEnter(VillainGameWorld world, Character character) {
        }

        public void onExit(VillainGameWorld world, Character character) {
        }
    }

    public static interface Action {
        public float update(Character var1, float var2, VillainGameWorld var3, GameContainer var4);

        public void onEnter(VillainGameWorld var1, Character var2);

        public void onExit(VillainGameWorld var1, Character var2);
    }
}

