/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Character;
import game.entities.Entity;
import game.entities.SelectionCoordinator;
import game.util.EntitySelectionHandler;
import game.world.VillainGameWorld;
import org.newdawn.slick.GameContainer;

public class CharacterSelection
extends Entity
implements EntitySelectionHandler {
    private Character character = null;
    private SelectionCoordinator coordinator;

    public CharacterSelection(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        this.coordinator = world.getEntities().getOne(SelectionCoordinator.class);
        this.coordinator.addHandler(this);
    }

    public void destroy(VillainGameWorld world) {
        super.destroy(world);
        this.coordinator.removeHandler(this);
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        if (this.character != null) {
            super.update(dt, world, container);
            this.setPos(this.character.getPos());
        }
    }

    public Character getCharacter() {
        return this.character;
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        if (this.character != null && !event.consumed() && event.type() == MouseEvent.Type.click && ((MouseClickEvent)event).rightClick()) {
            this.coordinator.deselect();
            event.consume();
        }
    }

    public void onSelectionChanged(Entity entity) {
        if (entity instanceof Character) {
            if (entity != null && entity != this.character) {
                entity.playAudio("default", 0.5f);
            }
            this.character = (Character)entity;
        } else {
            this.character = null;
        }
    }

    public BoundingBox getBounds() {
        return this.character == null ? super.getBounds() : this.character.getBounds();
    }
}

