/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.UserInterfacePane;
import game.ui.ScrollPane;
import game.ui.UIComponent;
import game.world.VillainGameWorld;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class Console
extends UserInterfacePane {
    private static final float PADDING = 5.0f;
    private ConsoleComponent internal;

    public Console(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void init(VillainGameWorld world) {
        this.internal = new ConsoleComponent();
        ScrollPane scrollPane = new ScrollPane(5.0f, 5.0f, this.getBounds().getWidth() - 10.0f, this.getBounds().getHeight() - 10.0f, 0.2f);
        scrollPane.setAuto(true);
        scrollPane.getContainer().addComponent(this.internal);
        this.getRootPane().addComponent(scrollPane);
        int i = 1;
        while (this.propertyMap.contains("hint" + i)) {
            String message = (String)this.propertyMap.get("hint" + i);
            this.addLine(message, MessageColor.HINT);
            ++i;
        }
    }

    public void addLine(String text, MessageColor messageColor) {
        this.internal.add(new ConsoleEntry(text, messageColor));
    }

    private class ConsoleComponent
    extends UIComponent {
        private ArrayList<ConsoleEntry> lines = new ArrayList();

        public void add(ConsoleEntry line) {
            this.lines.add(line);
            this.getSize().y = (float)this.getFont().getLineHeight() / 2.0f * (float)this.lines.size();
            this.pack();
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            g.scale(1.0f / world.getCamera().getScale(), 1.0f / world.getCamera().getScale());
            g.setFont(this.getFont());
            float dy = this.getFont().getLineHeight();
            float y = 0.0f;
            for (ConsoleEntry line : this.lines) {
                g.setColor(line.getMessageColor().getColor());
                g.drawString(line.getText(), 0.0f, y);
                y += dy;
            }
        }
    }

    private class ConsoleEntry {
        private String text;
        private MessageColor messageColor;

        public ConsoleEntry(String text, MessageColor messageColor) {
            this.text = text;
            this.messageColor = messageColor;
        }

        public MessageColor getMessageColor() {
            return this.messageColor;
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageColor {
        WARNING(new Color(1.0f, 0.0f, 0.0f)),
        TEXT(Color.white),
        HINT(Color.orange);

        private final Color color;

        private MessageColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

