/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseEvent;
import game.engine.loader.AssetStore;
import game.engine.loader.EntityDescriptor;
import game.engine.loader.PropertyStore;
import game.world.VillainGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.particles.ConfigurableEmitter;

public abstract class Entity {
    private static final float DEBUG_TEXT_SCALE = 0.5f;
    private static final int RENDER_BIN_DEFAULT = 0;
    private final int renderBin;
    private Vector2f pos;
    private float rotation;
    protected BoundingBox bounds;
    protected AssetStore<Animation> animations;
    protected String currentState;
    protected AssetStore<ConfigurableEmitter> emitters;
    protected AssetStore<Audio> audioMap;
    protected AssetStore<Font> fonts;
    protected PropertyStore propertyMap;
    protected float scale;
    private final String name;
    protected boolean transformedRendering;
    protected boolean customRendering;
    private boolean destroyed;

    public Entity(EntityDescriptor descriptor) {
        this.renderBin = descriptor.properties.getInt("renderbin", 0);
        this.name = descriptor.name;
        this.pos = new Vector2f(0.0f, 0.0f);
        this.rotation = 0.0f;
        this.bounds = descriptor.boundingBoxes.get("bounds");
        this.animations = descriptor.animations;
        this.currentState = "default";
        this.emitters = descriptor.particleEmitters;
        this.audioMap = descriptor.sounds;
        this.fonts = descriptor.fonts;
        this.propertyMap = descriptor.properties;
        this.scale = descriptor.scale;
        this.transformedRendering = true;
        this.customRendering = false;
    }

    public Vector2f getPos() {
        return this.pos;
    }

    public void init(VillainGameWorld world) {
    }

    public void destroy(VillainGameWorld world) {
        this.destroyed = true;
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
    }

    public int compareRenderOrder(Entity other) {
        return Integer.valueOf(this.renderBin).compareTo(other.renderBin);
    }

    public boolean preRender(Graphics g, VillainGameWorld world, GameContainer container) {
        if (!this.customRendering && this.animations.isEmpty()) {
            return false;
        }
        if (this.transformedRendering) {
            this.applyTransform(g);
        }
        return true;
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        if (this.animations.contains(this.currentState)) {
            Animation animation = this.animations.get(this.currentState);
            g.drawAnimation(animation, 0.0f, 0.0f);
        }
    }

    public void postRender(Graphics g, VillainGameWorld world, GameContainer container) {
        if (this.transformedRendering) {
            this.applyInverseTransform(g);
        }
    }

    protected void applyTransform(Graphics g) {
        g.translate(Math.round(this.pos.x), Math.round(this.pos.y));
        g.scale(this.scale, this.scale);
        g.rotate(0.0f, 0.0f, this.rotation);
    }

    protected void applyInverseTransform(Graphics g) {
        g.rotate(0.0f, 0.0f, -this.rotation);
        g.scale(1.0f / this.scale, 1.0f / this.scale);
        g.translate(-Math.round(this.pos.x), -Math.round(this.pos.y));
    }

    public void debug(Graphics g, VillainGameWorld world, GameContainer container) {
        BoundingBox bounds = this.getBounds();
        if (bounds != null) {
            g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.3f));
            g.fillRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
            g.setColor(Color.blue);
            g.drawRect(bounds.getMinX(this.pos), bounds.getMinY(this.pos), bounds.getWidth(), bounds.getHeight());
        }
        if (bounds != null) {
            g.pushTransform();
            g.translate(bounds.getMinX(this.pos), bounds.getMinY(this.pos));
            g.scale(0.5f, 0.5f);
            g.setColor(Color.red);
            g.drawString(this.name, 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void playAudio(String name, float volume) {
        this.audioMap.get(name).playAsSoundEffect(1.0f, volume, false);
    }

    public String getProperty(String key, String def) {
        String value = (String)this.propertyMap.get(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public void setPos(float x, float y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public void setPos(Vector2f worldPos) {
        this.setPos(worldPos.x, worldPos.y);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
    }

    public float getScale() {
        return this.scale;
    }
}

