/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Boss;
import game.entities.EntranceDisplay;
import game.entities.Hero;
import game.entities.HeroSpawner;
import game.entities.Traversable;
import game.world.VillainGameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.geom.Vector2f;

public class Entrance
extends Traversable {
    private float spawnInterval;
    private float spawnCountdown;
    private float delay;
    private boolean triggered;
    private HeroSpawner heroSpawner;
    private EntranceDisplay display;
    private float initialDelay;

    public Entrance(EntityDescriptor descriptor) {
        super(descriptor);
        this.spawnInterval = descriptor.properties.getFloat("spawninterval", 20.0f);
        this.delay = descriptor.properties.getFloat("initialdelay", 30.0f);
        this.initialDelay = descriptor.properties.getFloat("initialdelay", 30.0f);
        this.spawnCountdown = 0.0f;
        this.triggered = false;
    }

    public void trigger() {
        this.triggered = true;
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        Vector2f v = this.getPos();
        BoundingBox bb1 = this.getBounds();
        BoundingBox bb2 = this.display.getBounds();
        float x = bb1.getCenterX(v) - bb2.getWidth() / 2.0f;
        float y = bb1.getMinY(v) - bb2.getHeight();
        this.display.setPos(x, y);
        this.display.setProgress(this.heroSpawner.getSpawnedCount(), this.heroSpawner.getTotalCount());
        if (!this.triggered || this.finished()) {
            this.display.setTimer(0.0f, 0.0f);
        } else if (this.delay > 0.0f) {
            this.display.setTimer(this.delay, this.initialDelay);
        } else {
            this.display.setTimer(this.spawnCountdown, this.spawnInterval);
        }
        if (!this.triggered || this.finished()) {
            return;
        }
        this.delay -= (float)dt / 1000.0f;
        if (this.delay <= 0.0f) {
            this.spawnCountdown -= (float)dt / 1000.0f;
            if (this.spawnCountdown <= 0.0f) {
                this.spawnCountdown += this.spawnInterval;
                Hero hero = this.heroSpawner.spawnNextHero(world);
                if (world.getRandom().nextBoolean()) {
                    world.println("%s walked though the gates.", hero.getName());
                } else {
                    world.println("%s has entered your dungeon.", hero.getName());
                }
                hero.teleport(this);
                this.playAudio("spawn", 0.5f);
            }
        }
    }

    public boolean finished() {
        return this.heroSpawner.getSpawnedCount() == this.heroSpawner.getTotalCount();
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        this.display = (EntranceDisplay)world.getLoader().create("entrancedisplay");
        world.getEntities().add(this.display);
        Boss boss = (Boss)world.getLoader().create("boss");
        world.getEntities().add(boss);
        boss.teleport(this);
        this.heroSpawner = (HeroSpawner)world.getLoader().create("herospawner");
        world.getEntities().add(this.heroSpawner);
    }

    public void destroy(VillainGameWorld world) {
        super.destroy(world);
        world.getEntities().remove(this.display);
    }
}

