/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.VillainGameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class EntranceDisplay
extends Entity {
    private float time = 0.0f;
    private float maxTime = 0.0f;
    private int total = 0;
    private int spawned = 0;
    private float xoffset;

    public EntranceDisplay(EntityDescriptor descriptor) {
        super(descriptor);
        this.xoffset = descriptor.properties.getFloat("xoffset", 0.0f);
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        Font font = (Font)this.fonts.get("default");
        String s1 = String.format("%d", (int)this.time);
        String s2 = String.format("%d/%d", this.spawned, this.total);
        float h = this.getBounds().getHeight();
        float w = this.getBounds().getWidth();
        float h1 = font.getHeight(s1);
        float w1 = font.getWidth(s1);
        float h2 = font.getHeight(s2);
        float w2 = font.getWidth(s2);
        float hs = h - h1 - h2;
        g.setFont(font);
        g.setColor(Color.white);
        g.drawString(s1, this.xoffset, hs / 3.0f);
        g.drawString(s2, (w - w2) / 2.0f, 2.0f * hs / 3.0f + h1);
    }

    public void setTimer(float time, float total) {
        this.time = time;
        this.maxTime = total;
    }

    public void setProgress(int spawned, int total) {
        this.spawned = spawned;
        this.total = total;
    }
}

