/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Boss;
import game.entities.Room;
import game.entities.SelectionCoordinator;
import game.entities.Traversable;
import game.entities.Traverser;
import game.util.HeroDescriptor;
import game.world.VillainGameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hero
extends Traverser {
    private float moveSpeed;
    private State state;
    private Traversable current;
    private float stateTime;
    private float fightTime;
    private Random random;
    private int successionNumber;
    private int lootAmount;
    private String name;
    private ArrayList<String> funFacts;
    private String consoleName;
    private String weaknessText;
    private boolean hasPlayedDeathSound;
    private float swordSwingCooldown;
    private HashMap<HeroAttribute, Float> heroAttributes;
    private float deadTime;
    VillainGameWorld world;
    private float bossDamage;
    private float minSwingDelay;
    private float maxSwingDelay;
    private float maxSwingVolume;
    private float minSwingVolume;

    public Hero(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "walk";
        this.moveSpeed = descriptor.properties.getFloat("movespeed", 16.0f);
        this.fightTime = descriptor.properties.getFloat("fighttime", 5.0f);
        this.deadTime = descriptor.properties.getFloat("deadtime", 5.0f);
        this.minSwingDelay = descriptor.properties.getFloat("minswingdelay", 0.4f);
        this.maxSwingDelay = descriptor.properties.getFloat("maxswingdelay", 1.0f);
        this.minSwingVolume = descriptor.properties.getFloat("minswingvolume", 0.1f);
        this.maxSwingVolume = descriptor.properties.getFloat("maxswingvolume", 0.3f);
        this.state = State.idle;
        this.current = null;
        this.stateTime = 0.0f;
        this.hasPlayedDeathSound = false;
        this.swordSwingCooldown = 0.0f;
    }

    @Override
    public void init(VillainGameWorld world) {
        this.heroAttributes = new HashMap();
        this.funFacts = new ArrayList();
        this.setHeroAttributes(new HeroDescriptor());
        this.random = world.getRandom();
        this.world = world;
    }

    public int getCashWorth() {
        return this.lootAmount;
    }

    @Override
    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        MouseClickEvent click;
        super.handleMouseEvent(world, event);
        if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.click && (click = (MouseClickEvent)event).leftClick()) {
            world.getEntities().getOne(SelectionCoordinator.class).setSelection(this);
            click.consume();
        }
    }

    @Override
    public void update(int dt, VillainGameWorld world, GameContainer container) {
        this.currentState = this.state.animationState;
        Boss boss = world.getEntities().getOne(Boss.class);
        if (this.current == null) {
            world.getEntities().remove(this);
        } else if (this.state != State.dead && this.state != State.bossfight && boss != null && boss.getState() != Boss.State.dead && boss.getState() != Boss.State.fighting && boss.getCurrentTraversable() == this.current) {
            this.state = State.bossfight;
            boss.startFight(world, this);
        } else {
            this.stateTime += (float)dt / 1000.0f;
            BoundingBox bb = this.getBounds();
            Vector2f zero = new Vector2f(0.0f, 0.0f);
            Vector2f from = new Vector2f(-bb.getCenterX(zero), -bb.getCenterY(zero));
            Vector2f to = new Vector2f(-bb.getCenterX(zero), -bb.getCenterY(zero));
            switch (this.state) {
                case entering: {
                    from.add(this.current.getEntryPoint());
                    to.add(this.current.getMidPoint());
                    float distance = from.distance(to);
                    float time = distance / this.moveSpeed;
                    if (this.stateTime >= time) {
                        this.state = State.fighting;
                        this.stateTime -= time;
                        this.onFinishedEntering(this.current);
                        break;
                    }
                    float x = this.stateTime / time;
                    this.setPos((1.0f - x) * from.x + x * to.x, (1.0f - x) * from.y + x * to.y);
                    break;
                }
                case fighting: {
                    to.add(this.current.getMidPoint());
                    this.setPos(to);
                    this.updateSwordSwings(dt, world);
                    if (!(this.stateTime >= this.fightTime)) break;
                    this.state = State.exiting;
                    this.stateTime -= this.fightTime;
                    this.onStartExiting(this.current);
                    break;
                }
                case bossfight: {
                    to.add(this.current.getMidPoint());
                    to.x -= this.getBounds().getWidth() / 2.0f + 2.0f;
                    this.setPos(to);
                    this.updateSwordSwings(dt, world);
                    if (!(this.stateTime >= this.fightTime)) break;
                    if (boss != null && boss.getState() != Boss.State.dead) {
                        this.fightRoom((Room)this.current);
                        if (this.state != State.dead) {
                            this.fightMobs((Room)this.current);
                        }
                        boss.endFight(world, this);
                    }
                    if (this.state != State.dead) {
                        this.state = State.exiting;
                        this.onStartExiting(this.current);
                        this.stateTime -= this.fightTime;
                        break;
                    }
                    this.stateTime = 0.0f;
                    break;
                }
                case exiting: {
                    from.add(this.current.getMidPoint());
                    to.add(this.current.getExitPoint());
                    float distance = from.distance(to);
                    float time = distance / this.moveSpeed;
                    if (this.stateTime >= time) {
                        this.onFinishedExiting(this.current);
                        this.current = this.current.getNextTraversable();
                        this.state = State.entering;
                        this.stateTime -= time;
                        if (this.current == null) break;
                        this.onStartEntering(this.current);
                        break;
                    }
                    float x = this.stateTime / time;
                    this.setPos((1.0f - x) * from.x + x * to.x, (1.0f - x) * from.y + x * to.y);
                    break;
                }
                case dead: {
                    if (!this.hasPlayedDeathSound) {
                        this.hasPlayedDeathSound = true;
                        this.playAudio("death", 0.5f);
                    }
                    if (!(this.stateTime >= this.deadTime)) break;
                    this.onStartExiting(this.current);
                    this.onFinishedExiting(this.current);
                    world.getEntities().remove(this);
                }
            }
        }
    }

    private void updateSwordSwings(int dt, VillainGameWorld world) {
        this.swordSwingCooldown -= (float)dt / 1000.0f;
        if (this.swordSwingCooldown <= 0.0f) {
            int r = world.getRandom().nextInt(2);
            float volume = world.getRandom().nextFloat() * (this.maxSwingVolume - this.minSwingVolume) + this.minSwingVolume;
            this.playAudio("hit" + (r + 1), volume);
            this.swordSwingCooldown += world.getRandom().nextFloat() * (this.maxSwingDelay - this.minSwingDelay) + this.minSwingDelay;
        }
    }

    @Override
    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        if (world.getEntities().getOne(SelectionCoordinator.class).getSelection() == this) {
            g.drawAnimation((Animation)this.animations.get("selection"), 0.0f, 0.0f);
        }
    }

    public void setHeroAttributes(HeroDescriptor heroDescriptor) {
        this.heroAttributes.put(HeroAttribute.lava, Float.valueOf(heroDescriptor.lavaResistance));
        this.heroAttributes.put(HeroAttribute.spike, Float.valueOf(heroDescriptor.spikeResistance));
        this.heroAttributes.put(HeroAttribute.electricity, Float.valueOf(heroDescriptor.electricityResistance));
        this.heroAttributes.put(HeroAttribute.haunted, Float.valueOf(heroDescriptor.hauntedResistance));
        this.heroAttributes.put(HeroAttribute.saw, Float.valueOf(heroDescriptor.sawResistance));
        this.heroAttributes.put(HeroAttribute.strength, Float.valueOf(heroDescriptor.strength));
        this.heroAttributes.put(HeroAttribute.defense, Float.valueOf(heroDescriptor.defense));
        this.heroAttributes.put(HeroAttribute.hitpoints, Float.valueOf(heroDescriptor.startingHitpoints));
        this.heroAttributes.put(HeroAttribute.maxhitpoints, Float.valueOf(heroDescriptor.startingHitpoints));
        this.successionNumber = heroDescriptor.successionNumber;
        this.lootAmount = heroDescriptor.lootAmount;
        this.weaknessText = heroDescriptor.weaknesses;
        this.name = heroDescriptor.fullHeroName;
        this.funFacts.clear();
        this.funFacts.add(heroDescriptor.factText0);
        this.funFacts.add(heroDescriptor.factText1);
        this.funFacts.add(heroDescriptor.factText2);
        this.consoleName = heroDescriptor.consoleName;
        this.bossDamage = heroDescriptor.maxBossDamage;
    }

    public void teleport(Traversable traversable) {
        if (this.current != null) {
            if (this.state != State.exiting) {
                this.onStartExiting(this.current);
            }
            this.onFinishedExiting(this.current);
        }
        this.current = traversable;
        this.setPos(traversable.getMidPoint());
        this.state = State.exiting;
        this.onStartEntering(this.current);
        this.onFinishedEntering(this.current);
        this.onStartExiting(this.current);
    }

    @Override
    public void onStartExiting(Traversable traversable) {
        traversable.onStartExiting(this);
        if (this.state == State.dead || traversable.getPreviousTraversable() == null) {
            return;
        }
        Room currentRoom = (Room)traversable;
        this.fightRoom(currentRoom);
        if (this.state != State.dead) {
            this.fightMobs(currentRoom);
        }
    }

    private void fightRoom(Room currentRoom) {
        float heroDMGReduce;
        if (this.random.nextFloat() <= (float)(currentRoom.getUpgradeLevel() + 1) * 0.01f) {
            switch (currentRoom.getAssociatedResistance()) {
                case lava: {
                    this.world.println("%s tripped and fell into a pool of lava.", this.name);
                    break;
                }
                case spike: {
                    this.world.println("%s passed away due to corporeal perforation.", this.name);
                    break;
                }
                case electricity: {
                    this.world.println("%s died by touching an electrical rod.", this.name);
                    break;
                }
                case haunted: {
                    this.world.println("%s was scared to death.", this.name);
                    break;
                }
                case saw: {
                    this.world.println("%s was split into two!", this.name);
                }
            }
            this.state = State.dead;
            this.world.getBoss().earnCash(this.getCashWorth());
            return;
        }
        float hitpoints = this.heroAttributes.get((Object)HeroAttribute.hitpoints).floatValue();
        float roomDMGPercent = currentRoom.getLevelEffectiveness();
        float roomDMG = roomDMGPercent * 0.01f * (100.0f - (heroDMGReduce = this.heroAttributes.get((Object)currentRoom.getAssociatedResistance()).floatValue()));
        if ((hitpoints -= roomDMG) <= 0.0f) {
            this.world.println("%s mysteriously turned into a skeleton.", this.name);
            this.state = State.dead;
            this.world.getBoss().earnCash(this.getCashWorth());
            return;
        }
        this.heroAttributes.put(HeroAttribute.hitpoints, Float.valueOf(Math.max(hitpoints, 0.0f)));
    }

    private void fightMobs(Room currentRoom) {
        float hitpoints = this.heroAttributes.get((Object)HeroAttribute.hitpoints).floatValue();
        int pickFightWith = (int)Math.ceil((float)currentRoom.getNbrMobs() * this.random.nextFloat());
        float mobStrength = currentRoom.getLevelMobStrength();
        float heroStrength = this.heroAttributes.get((Object)HeroAttribute.strength).floatValue() - (float)(5 * currentRoom.getUpgradeLevel());
        float heroDefense = this.heroAttributes.get((Object)HeroAttribute.defense).floatValue();
        float mobDMG = mobStrength * (1.0f - heroDefense * 0.01f);
        int deadMobs = 0;
        for (int mob = 0; mob < pickFightWith; ++mob) {
            if (this.random.nextFloat() <= 0.01f * heroStrength) {
                currentRoom.killMob();
                ++deadMobs;
                continue;
            }
            if (!((hitpoints -= mobDMG) < 0.0f)) continue;
            this.state = State.dead;
            this.world.getBoss().earnCash(this.getCashWorth());
            hitpoints = 0.0f;
            break;
        }
        switch (this.state) {
            case dead: {
                this.world.println("%s was felled in battle by %d of your minions.", this.name, pickFightWith);
                break;
            }
            default: {
                if (this.world.getBoss().getCurrentTraversable() == currentRoom) break;
                if (pickFightWith == 0) {
                    if (this.world.getRandom().nextBoolean()) {
                        this.world.println("%s managed to navigate through the %s.", this.consoleName, currentRoom.getName().toLowerCase());
                        break;
                    }
                    this.world.println("%s moved to the next room.", this.consoleName);
                    break;
                }
                if (deadMobs == 0) {
                    if (pickFightWith == 1) {
                        this.world.println("%s was attacked by a minions but escaped.", this.consoleName);
                        break;
                    }
                    this.world.println("%s was ambushed by %d minions but managed to escape.", this.consoleName, pickFightWith);
                    break;
                }
                if (deadMobs == pickFightWith) {
                    if (deadMobs == 1) {
                        this.world.println("%s slayed one of your minions!", this.consoleName);
                        break;
                    }
                    this.world.println("%s fought with %d minions and slayed them all!", this.consoleName, deadMobs);
                    break;
                }
                this.world.println("%s encountered %d minions and killed %d of them.", this.consoleName, pickFightWith, deadMobs);
            }
        }
        this.heroAttributes.put(HeroAttribute.hitpoints, Float.valueOf(hitpoints));
    }

    public String getName() {
        return this.name;
    }

    public float getHitpoints() {
        return this.heroAttributes.get((Object)HeroAttribute.hitpoints).floatValue();
    }

    public float getMaxHitpoints() {
        return this.heroAttributes.get((Object)HeroAttribute.maxhitpoints).floatValue();
    }

    public Animation getPortrait() {
        return (Animation)this.animations.get("portrait");
    }

    public ArrayList<String> getFunFacts() {
        return this.funFacts;
    }

    public String getWeaknesses() {
        return this.weaknessText;
    }

    public float getBossDMG() {
        return this.bossDamage;
    }

    public void slainByBoss(VillainGameWorld world) {
        this.state = State.dead;
        this.playAudio("slain", 0.5f);
        this.heroAttributes.put(HeroAttribute.hitpoints, Float.valueOf(0.0f));
        this.hasPlayedDeathSound = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeroAttribute {
        lava,
        spike,
        electricity,
        haunted,
        saw,
        strength,
        defense,
        hitpoints,
        maxhitpoints;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        idle("idle"),
        entering("walk"),
        fighting("fight"),
        bossfight("fight"),
        exiting("walk"),
        dead("dead");

        private String animationState;

        private State(String animationState) {
            this.animationState = animationState;
        }
    }
}

