/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.world.VillainGameWorld;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeroFactGenerator
extends Entity {
    private ArrayList<String> prefixes;
    private ArrayList<String> names;
    private ArrayList<String> epithets;
    private ArrayList<String> verbs;
    private ArrayList<String> nouns;
    private Random random;

    public HeroFactGenerator(EntityDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public void init(VillainGameWorld world) {
        this.random = world.getRandom();
        this.prefixes = new ArrayList();
        this.names = new ArrayList();
        this.epithets = new ArrayList();
        this.verbs = new ArrayList();
        this.nouns = new ArrayList();
        this.readTextFiles();
    }

    public HeroFacts generateFacts() {
        int verbIndex2;
        int verbIndex1;
        int nounIndex2;
        int nounIndex1;
        HeroFacts hf = new HeroFacts();
        hf.prefix = this.pickRandomListEntry(this.prefixes);
        hf.name = this.pickRandomListEntry(this.names);
        hf.epithet = this.pickRandomListEntry(this.epithets);
        int nounIndex0 = this.random.nextInt(this.nouns.size());
        while (nounIndex0 == (nounIndex1 = this.random.nextInt(this.nouns.size()))) {
        }
        while ((nounIndex2 = this.random.nextInt(this.nouns.size())) == nounIndex1 || nounIndex2 == nounIndex0) {
        }
        int verbIndex0 = this.random.nextInt(this.verbs.size());
        while (verbIndex0 == (verbIndex1 = this.random.nextInt(this.verbs.size()))) {
        }
        while ((verbIndex2 = this.random.nextInt(this.verbs.size())) == verbIndex1 || verbIndex2 == verbIndex0) {
        }
        hf.verb0 = this.verbs.get(verbIndex0);
        hf.noun0 = this.nouns.get(nounIndex0);
        hf.verb1 = this.verbs.get(verbIndex1);
        hf.noun1 = this.nouns.get(nounIndex1);
        hf.verb2 = this.verbs.get(verbIndex2);
        hf.noun2 = this.nouns.get(nounIndex2);
        return hf;
    }

    private String pickRandomListEntry(ArrayList<String> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private void readTextFiles() {
        this.readFile("prefixes", this.prefixes);
        this.readFile("names", this.names);
        this.readFile("epithets", this.epithets);
        this.readFile("verbs", this.verbs);
        this.readFile("nouns", this.nouns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String fileName, ArrayList<String> list) {
        String fullPath = "/assets/text/" + fileName + ".txt";
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(fullPath)));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public class HeroFacts {
        public String prefix;
        public String name;
        public String epithet;
        public String verb0;
        public String noun0;
        public String verb1;
        public String noun1;
        public String verb2;
        public String noun2;
    }
}

