/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Hero;
import game.entities.HeroFactGenerator;
import game.entities.PredefinedDescriptor;
import game.util.HeroDescriptor;
import game.world.VillainGameWorld;
import java.util.ArrayList;
import java.util.Random;

public class HeroSpawner
extends Entity {
    private static final int INDEX_OF_BADASS_HERO = 5;
    private HeroFactGenerator heroFactGenerator;
    private ArrayList<HeroDescriptor> descriptors;
    private int spawnedHeroes;
    private int nbrPredefinedHeroes;
    private int nbrBadAssHeroes;
    private int nbrNormalHeroes;
    private Random random;

    public HeroSpawner(EntityDescriptor descriptor) {
        super(descriptor);
        this.nbrPredefinedHeroes = descriptor.properties.getInt("nbrpredefinedheroes");
        this.nbrBadAssHeroes = descriptor.properties.getInt("nbrbadassheroes");
        this.nbrNormalHeroes = this.nbrPredefinedHeroes - this.nbrBadAssHeroes;
        this.spawnedHeroes = 0;
    }

    public void init(VillainGameWorld world) {
        this.heroFactGenerator = (HeroFactGenerator)world.getLoader().create("herofactgenerator");
        world.getEntities().add(this.heroFactGenerator);
        this.random = world.getRandom();
        this.descriptors = new ArrayList(this.nbrPredefinedHeroes);
        for (int heroIndex = 0; heroIndex < this.nbrPredefinedHeroes; ++heroIndex) {
            PredefinedDescriptor predefinedDescriptor = (PredefinedDescriptor)world.getLoader().create("predefineddescriptor" + heroIndex);
            world.getEntities().add(predefinedDescriptor);
            HeroDescriptor heroDescriptor = predefinedDescriptor.getDescriptor();
            HeroFactGenerator.HeroFacts heroFacts = this.heroFactGenerator.generateFacts();
            heroDescriptor.consoleName = heroFacts.prefix + heroFacts.name;
            heroDescriptor.fullHeroName = heroDescriptor.consoleName + heroFacts.epithet;
            heroDescriptor.factText0 = heroFacts.verb0 + heroFacts.noun0;
            heroDescriptor.factText1 = heroFacts.verb1 + heroFacts.noun1;
            heroDescriptor.factText2 = heroFacts.verb2 + heroFacts.noun2;
            this.descriptors.add(heroDescriptor);
        }
    }

    public Hero spawnNextHero(VillainGameWorld world) {
        Hero hero;
        if (this.spawnedHeroes == this.nbrPredefinedHeroes) {
            return null;
        }
        if (this.spawnedHeroes < this.nbrNormalHeroes) {
            hero = (Hero)world.getLoader().create("hero" + (1 + this.random.nextInt(4)));
            world.getEntities().add(hero);
        } else {
            hero = (Hero)world.getLoader().create("hero5");
            world.getEntities().add(hero);
        }
        hero.setHeroAttributes(this.descriptors.get(this.spawnedHeroes++));
        return hero;
    }

    public int getSpawnedCount() {
        return this.spawnedHeroes;
    }

    public int getTotalCount() {
        return this.nbrPredefinedHeroes;
    }
}

