/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Boss;
import game.entities.CharacterSelection;
import game.entities.Hero;
import game.entities.Room;
import game.entities.RoomSelection;
import game.entities.UserInterfacePane;
import game.ui.UIComponent;
import game.world.VillainGameWorld;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class InformationBox
extends UserInterfacePane {
    private static final float PADDING_TOP = 5.0f;
    private static final float PADDING_BOTTOM = 18.0f;
    private static final float PADDING_LEFT = 5.0f;
    private SwitchComponent switchComponent;
    private StandardInfoComponent standard;
    private RoomInfoComponent room;
    private HeroInfoComponent hero;
    private BossInfoComponent boss;
    private Room overrideRoom;

    public InformationBox(EntityDescriptor descriptor) {
        super(descriptor);
        float width = this.getBounds().getWidth() - 10.0f;
        float height = this.getBounds().getHeight() - 5.0f - 18.0f;
        this.switchComponent = new SwitchComponent(5.0f, 5.0f, width, height);
        this.getRootPane().addComponent(this.switchComponent);
        this.standard = new StandardInfoComponent(0.0f, 0.0f, width, height);
        this.switchComponent.addOption(State.standard.name(), this.standard);
        this.room = new RoomInfoComponent(0.0f, 0.0f, width, height);
        this.switchComponent.addOption(State.room.name(), this.room);
        this.hero = new HeroInfoComponent(0.0f, 0.0f, width, height);
        this.switchComponent.addOption(State.hero.name(), this.hero);
        this.boss = new BossInfoComponent(0.0f, 0.0f, width, height);
        this.switchComponent.addOption(State.boss.name(), this.boss);
    }

    public void overrideRoom(Room room) {
        this.overrideRoom = room;
    }

    public Room getOverrideRoom() {
        return this.overrideRoom;
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        RoomSelection roomSelection = world.getEntities().getOne(RoomSelection.class);
        CharacterSelection characterSelection = world.getEntities().getOne(CharacterSelection.class);
        if (this.overrideRoom != null) {
            this.room.setRoom(this.overrideRoom);
            this.switchComponent.setOption(State.room.name());
        } else if (roomSelection.getRoom() != null) {
            this.room.setRoom(roomSelection.getRoom());
            this.switchComponent.setOption(State.room.name());
        } else if (characterSelection.getCharacter() != null) {
            Boss boss = world.getEntities().getOne(Boss.class);
            if (characterSelection.getCharacter() == boss) {
                this.boss.setBoss(boss);
                this.switchComponent.setOption(State.boss.name());
            } else {
                this.hero.setHero((Hero)characterSelection.getCharacter());
                this.switchComponent.setOption(State.hero.name());
            }
        } else {
            this.switchComponent.setOption(State.standard.name());
        }
    }

    public class BossInfoComponent
    extends UIComponent {
        private Boss boss;

        public BossInfoComponent(float x, float y, float w, float h) {
            super(x, y, w, h);
            this.boss = null;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            float dy = this.getFont().getLineHeight();
            float x = 0.0f;
            float y = dy;
            g.scale(0.5f, 0.5f);
            g.setFont(this.getFont());
            g.setColor(Color.red);
            String s = this.boss.getName();
            int w = this.getFont().getWidth(s);
            g.drawString(s, Math.round((this.getSize().x * 2.0f - (float)w) / 2.0f), y);
            g.scale(2.0f, 2.0f);
            Animation p = this.boss.getPortrait();
            g.drawAnimation(p, (this.getSize().x - (float)p.getWidth()) / 2.0f, (y += dy) / 2.0f);
            float healthNormalized = this.boss.getHitpoints() / this.boss.getMaxHitpoints();
            g.setColor(this.boss.getColorFromNormalizedHealth(healthNormalized));
            g.fillRect((this.getSize().x - (float)p.getWidth()) / 2.0f, y / 2.0f + (float)p.getHeight(), (float)p.getWidth() * healthNormalized, 4.0f);
            g.setColor(Color.lightGray);
            g.drawRect((this.getSize().x - (float)p.getWidth()) / 2.0f, y / 2.0f + (float)p.getHeight(), p.getWidth(), 4.0f);
            g.scale(0.5f, 0.5f);
            y += (float)p.getHeight() * 2.0f + dy + 4.0f;
            x += dy;
            g.setColor(Color.white);
            int hp = (int)(100.0f * healthNormalized + 0.5f);
            s = String.format("%s %d%%", "Health:", hp);
            int w2 = this.getFont().getWidth(s);
            g.drawString(s, (this.getSize().x * 2.0f - (float)w2) / 2.0f, y);
            y += dy;
        }

        public void setBoss(Boss boss) {
            this.boss = boss;
        }
    }

    public class HeroInfoComponent
    extends UIComponent {
        private Hero hero;

        public HeroInfoComponent(float x, float y, float w, float h) {
            super(x, y, w, h);
            this.hero = null;
        }

        public void setHero(Hero hero) {
            this.hero = hero;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            float dy = this.getFont().getLineHeight();
            float x = 0.0f;
            float y = dy;
            g.scale(0.5f, 0.5f);
            g.setFont(this.getFont());
            g.setColor(Color.red);
            String s = this.hero.getName();
            int w = this.getFont().getWidth(s);
            g.drawString(s, Math.round((this.getSize().x * 2.0f - (float)w) / 2.0f), y);
            g.scale(2.0f, 2.0f);
            Animation p = this.hero.getPortrait();
            g.drawAnimation(p, (this.getSize().x - (float)p.getWidth()) / 2.0f, (y += dy) / 2.0f);
            float healthNormalized = this.hero.getHitpoints() / this.hero.getMaxHitpoints();
            g.setColor(this.hero.getColorFromNormalizedHealth(healthNormalized));
            g.fillRect((this.getSize().x - (float)p.getWidth()) / 2.0f, y / 2.0f + (float)p.getHeight(), (float)p.getWidth() * healthNormalized, 4.0f);
            g.setColor(Color.lightGray);
            g.drawRect((this.getSize().x - (float)p.getWidth()) / 2.0f, y / 2.0f + (float)p.getHeight(), p.getWidth(), 4.0f);
            g.scale(0.5f, 0.5f);
            y += (float)p.getHeight() * 2.0f + dy + 4.0f;
            x += dy;
            g.setColor(Color.white);
            int hp = (int)(100.0f * healthNormalized + 0.5f);
            s = String.format("%s %d%%", "Health:", hp);
            int w2 = this.getFont().getWidth(s);
            g.drawString(s, Math.round((this.getSize().x * 2.0f - (float)w2) / 2.0f), y);
            y += dy;
            for (int fact = 0; fact < this.hero.getFunFacts().size(); ++fact) {
                g.setColor(Color.white);
                s = this.hero.getFunFacts().get(fact);
                w2 = this.getFont().getWidth(s);
                g.drawString(s, Math.round((this.getSize().x * 2.0f - (float)w2) / 2.0f), y);
                y += dy;
            }
            g.setColor(Color.yellow);
            hp = (int)(100.0f * healthNormalized + 0.5f);
            s = this.hero.getWeaknesses();
            w2 = this.getFont().getWidth(s);
            g.drawString(s, Math.round((this.getSize().x * 2.0f - (float)w2) / 2.0f), y);
            y += dy;
        }
    }

    public class RoomInfoComponent
    extends UIComponent {
        private Room room;

        public RoomInfoComponent(float x, float y, float w, float h) {
            super(x, y, w, h);
            this.room = null;
        }

        public void setRoom(Room r) {
            this.room = r;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            float x = 0.0f;
            float y = 0.0f;
            float dy = this.getFont().getLineHeight();
            g.scale(0.5f, 0.5f);
            g.setFont(this.getFont());
            g.setColor(Color.red);
            String s = this.room.getName();
            g.drawString(s, x, y);
            g.setColor(Color.white);
            boolean max = this.room.getUpgradeLevel() >= this.room.getMaxLevel();
            s = String.format("%-9s %d %s", "Level:", this.room.getUpgradeLevel() + 1, max ? "(max)" : "($" + this.room.getUpgradePrice() + ")");
            g.drawString(s, x += dy, y += dy);
            g.setColor(Color.white);
            max = this.room.getNbrMobs() >= this.room.getMaxMobs();
            s = String.format("%-9s %d %s", "Mobs:", this.room.getNbrMobs(), max ? "(max)" : "($" + this.room.getNextMobPrice() + ")");
            g.drawString(s, x, y += dy);
            g.setColor(Color.white);
            s = String.format("%-9s %d - %d", "Strength:", this.room.getMinStrength(), this.room.getMaxStrength());
            g.drawString(s, x, y += dy);
            y += dy;
        }
    }

    public class StandardInfoComponent
    extends UIComponent {
        public StandardInfoComponent(float x, float y, float w, float h) {
            super(x, y, w, h);
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            g.setFont(this.getFont());
            float y = 0.0f;
            float dy = this.getFont().getLineHeight();
            g.setColor(Color.white);
            String s = "Legend";
            int w = this.getFont().getWidth(s);
            g.drawString(s, (this.getSize().x - (float)w) / 2.0f, y);
            y += 2.0f * dy;
            StringBuffer sb = new StringBuffer();
            sb.append("You are an evil boss who\n");
            sb.append("has kidnapped a princess.\n");
            sb.append("\n");
            sb.append("All the heroes of the\n");
            sb.append("land are now trying to\n");
            sb.append("save her.\n");
            sb.append("\n");
            sb.append("You must stop them and\n");
            sb.append("at the same time stay \n");
            sb.append("alive.\n");
            sb.append("\n");
            sb.append("Build a chain of lethal\n");
            sb.append("chambers in your dungeon.\n");
            g.scale(0.5f, 0.5f);
            g.drawString(sb.toString(), 0.0f, y);
        }

        public void update(int dt, VillainGameWorld world, GameContainer container) {
            super.update(dt, world, container);
        }
    }

    public static class SwitchComponent
    extends UIComponent {
        private HashMap<String, UIComponent> options = new HashMap();
        private UIComponent currentOption = null;

        public SwitchComponent(float x, float y, float w, float h) {
            super(x, y, w, h);
        }

        public void addOption(String id, UIComponent option) {
            if (this.options.isEmpty()) {
                this.currentOption = option;
            }
            this.options.put(id, option);
            option.setParent(this);
        }

        public void setOption(String id) {
            if (!this.options.containsKey(id)) {
                throw new RuntimeException("Invalid option id.");
            }
            this.currentOption = this.options.get(id);
        }

        protected void internalPack() {
            super.internalPack();
            Vector2f cs = this.getSize();
            cs.set(this.currentOption.getPos());
            cs.add(this.currentOption.getSize());
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            super.render(g, world, container);
            this.currentOption.render(g, world, container);
        }

        public void update(int dt, VillainGameWorld world, GameContainer container) {
            super.update(dt, world, container);
            this.currentOption.update(dt, world, container);
        }

        public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
            super.handleMouseEvent(world, event);
            this.currentOption.handleMouseEvent(world, event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        standard,
        room,
        hero,
        boss;

    }
}

