/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Hero;
import game.entities.SelectionCoordinator;
import game.entities.Traversable;
import game.world.VillainGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class Room
extends Traversable {
    private static final float PADDING_EDGE = 4.0f;
    private static final int LEVEL_COUNT = 3;
    private Hero.HeroAttribute associatedResistance;
    private float[] levelEffectiveness;
    private float[] mobStrengths;
    private int[] prices;
    private String name;
    private int mobCount;
    private int upgradeLevel;
    private int initialMobPrice;
    private int additionalMobPrice;

    public Room(EntityDescriptor descriptor) {
        super(descriptor);
        this.currentState = "level0";
        this.name = descriptor.properties.get("name", "[" + descriptor.name + "]");
        this.prices = descriptor.properties.getIntArray("price", 0, 0, 0);
        this.initialMobPrice = descriptor.properties.getInt("initialmobprice", 0);
        this.additionalMobPrice = descriptor.properties.getInt("additionalmobprice", 0);
        this.associatedResistance = Hero.HeroAttribute.valueOf((String)descriptor.properties.get("affectedattribute"));
        this.levelEffectiveness = new float[3];
        this.levelEffectiveness[0] = descriptor.properties.getFloat("level0");
        this.levelEffectiveness[1] = descriptor.properties.getFloat("level1");
        this.levelEffectiveness[2] = descriptor.properties.getFloat("level2");
        this.mobStrengths = new float[3];
        this.mobStrengths[0] = descriptor.properties.getFloat("mobstrength0");
        this.mobStrengths[1] = descriptor.properties.getFloat("mobstrength1");
        this.mobStrengths[2] = descriptor.properties.getFloat("mobstrength2");
        this.mobCount = 0;
        this.upgradeLevel = 0;
    }

    public int getPrice() {
        return this.prices[0];
    }

    public int getUpgradePrice() {
        return this.prices[this.upgradeLevel + 1];
    }

    public String getName() {
        return this.name;
    }

    public float getLevelEffectiveness() {
        return this.levelEffectiveness[this.upgradeLevel];
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public void upgrade() {
        ++this.upgradeLevel;
        this.currentState = "level" + this.upgradeLevel;
    }

    public int getMaxLevel() {
        return 2;
    }

    public int getNbrMobs() {
        return this.mobCount;
    }

    public void killMob() {
        --this.mobCount;
    }

    public void addMob() {
        ++this.mobCount;
    }

    public int getNextMobPrice() {
        return this.initialMobPrice + this.mobCount * this.additionalMobPrice;
    }

    public int getMaxMobs() {
        return 99;
    }

    public float getLevelMobStrength() {
        return this.mobStrengths[this.upgradeLevel];
    }

    public Hero.HeroAttribute getAssociatedResistance() {
        return this.associatedResistance;
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        if (world.getEntities().getOne(SelectionCoordinator.class).getSelection() == this) {
            g.drawAnimation((Animation)this.animations.get("selection"), 0.0f, 0.0f);
        }
        if (this.getPreviousTraversable() != null) {
            Font font = (Font)this.fonts.get("default");
            g.setFont(font);
            g.setColor(Color.red);
            String str = String.valueOf(this.getNbrMobs());
            float w = font.getWidth(str);
            g.drawString(str, this.getBounds().getWidth() - w - 4.0f, 4.0f);
        }
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        MouseClickEvent click;
        super.handleMouseEvent(world, event);
        if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.click && (click = (MouseClickEvent)event).leftClick()) {
            world.getEntities().getOne(SelectionCoordinator.class).setSelection(this);
            click.consume();
        }
    }

    public int getMinStrength() {
        return (int)this.getLevelEffectiveness();
    }

    public int getMaxStrength() {
        return (int)(this.getLevelEffectiveness() + this.getLevelMobStrength() * (float)this.getNbrMobs());
    }
}

