/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Room;
import game.entities.World;
import game.util.PlacementRestriction;
import game.util.Position;
import game.world.VillainGameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class RoomCursor
extends Entity {
    public Room room = null;
    private PlacementRestriction restriction;
    private PlacementState placementState;

    public RoomCursor(EntityDescriptor descriptor) {
        super(descriptor);
        this.customRendering = true;
        this.placementState = PlacementState.illegal;
        this.restriction = PlacementRestriction.ANY;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public void setPlacementRestriction(PlacementRestriction restriction) {
        this.restriction = restriction;
    }

    public void update(int dt, VillainGameWorld gameWorld, GameContainer container) {
        if (this.room != null) {
            World world = gameWorld.getWorld();
            int mouseX = container.getInput().getMouseX();
            int mouseY = container.getInput().getMouseY();
            Vector2f mouseWorld = gameWorld.getCamera().screenToWorld(mouseX, mouseY);
            mouseWorld.x -= this.room.getBounds().getWidth() / 2.0f;
            mouseWorld.y -= this.room.getBounds().getHeight() / 2.0f;
            Position p = world.toPosRounded(mouseWorld);
            int tx = Math.max(0, Math.min(world.getWidth() - this.room.getWidth(), p.x));
            int ty = Math.max(0, Math.min(world.getHeight() - this.room.getHeight(), p.y));
            this.setPos(world.toWorld(new Position(tx, ty)));
            this.placementState = this.restriction.allowed(this.room, tx, ty) && gameWorld.getBoss().hasCash(this.room.getPrice()) ? PlacementState.legal : PlacementState.illegal;
        }
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        this.room.render(g, world, container);
        g.setColor(this.placementState.bg);
        BoundingBox bb = this.room.getBounds();
        g.fillRect(0.0f, 0.0f, bb.getWidth(), bb.getHeight());
        g.setColor(this.placementState.line);
        g.drawRect(0.0f, 0.0f, bb.getWidth(), bb.getHeight());
    }

    public BoundingBox getBounds() {
        return this.room == null ? super.getBounds() : this.room.getBounds();
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        world.getWorld().setAccessability(this.room);
    }

    public void destroy(VillainGameWorld world) {
        super.destroy(world);
        world.getWorld().setAccessability(null);
    }

    public void handleMouseEvent(VillainGameWorld gameWorld, MouseEvent event) {
        super.handleMouseEvent(gameWorld, event);
        if (this.room != null && !event.consumed() && event.type() == MouseEvent.Type.click) {
            World world = gameWorld.getWorld();
            MouseClickEvent click = (MouseClickEvent)event;
            if (click.rightClick()) {
                this.room = null;
                gameWorld.getEntities().remove(this);
                click.consume();
            } else if (click.leftClick()) {
                BoundingBox bb = this.getBounds();
                Vector2f v = this.getPos();
                float wx = click.x + bb.getMinX(v);
                float wy = click.y + bb.getMinY(v);
                Vector2f mw = new Vector2f(wx, wy);
                if (world.getBounds().contains(world.getPos(), mw)) {
                    if (this.placementState == PlacementState.legal) {
                        if (gameWorld.getBoss().deductCash(this.room.getPrice())) {
                            mw.x -= this.room.getBounds().getWidth() / 2.0f;
                            mw.y -= this.room.getBounds().getHeight() / 2.0f;
                            Position p = world.toPosRounded(mw);
                            int tx = Math.max(0, Math.min(world.getWidth() - this.room.getWidth(), p.x));
                            int ty = Math.max(0, Math.min(world.getHeight() - this.room.getHeight(), p.y));
                            world.placeRoom(gameWorld, this.room, new Position(tx, ty));
                            this.playAudio("buy", 0.5f);
                        }
                        this.room = null;
                        gameWorld.getEntities().remove(this);
                        click.consume();
                    } else {
                        click.consume();
                    }
                } else {
                    this.room = null;
                    gameWorld.getEntities().remove(this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PlacementState {
        legal(new Color(0.0f, 1.0f, 0.0f, 0.3f), new Color(0.0f, 1.0f, 0.0f, 1.0f)),
        illegal(new Color(1.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 0.0f, 0.0f, 1.0f));

        public final Color bg;
        public final Color line;

        private PlacementState(Color bg, Color line) {
            this.bg = bg;
            this.line = line;
        }
    }
}

