/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseClickEvent;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Room;
import game.entities.SelectionCoordinator;
import game.entities.UserInterfacePane;
import game.ui.UIComponent;
import game.util.EntitySelectionHandler;
import game.world.VillainGameWorld;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class RoomSelection
extends UserInterfacePane
implements EntitySelectionHandler {
    private Button upgradeButton = new Button((Animation)this.animations.get("upgradebutton"));
    private Button mobButton = new Button((Animation)this.animations.get("mobbutton"));
    private Room room = null;
    private SelectionCoordinator coordinator;

    public RoomSelection(EntityDescriptor descriptor) {
        super(descriptor);
        this.getRootPane().addComponent(this.upgradeButton);
        this.getRootPane().addComponent(this.mobButton);
        Vector2f up = new Vector2f(0.0f, 0.0f);
        this.upgradeButton.setPos(up);
        Vector2f mp = new Vector2f(this.upgradeButton.getSize().x, 0.0f);
        this.mobButton.setPos(mp);
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        this.coordinator = world.getEntities().getOne(SelectionCoordinator.class);
        this.coordinator.addHandler(this);
    }

    public void destroy(VillainGameWorld world) {
        super.destroy(world);
        this.coordinator.removeHandler(this);
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        if (this.room != null) {
            boolean shouldHideBuyMob;
            boolean shouldHideUpgrade;
            super.update(dt, world, container);
            Vector2f pos = new Vector2f(this.room.getPos());
            pos.y -= this.upgradeButton.getSize().y;
            pos.x += this.room.getBounds().getWidth() - this.upgradeButton.getSize().x - this.mobButton.getSize().x;
            this.setPos(pos);
            boolean bl = shouldHideUpgrade = this.room.getUpgradeLevel() >= this.room.getMaxLevel();
            if (shouldHideUpgrade != this.upgradeButton.isHidden()) {
                this.upgradeButton.setHidden(shouldHideUpgrade);
            }
            boolean bl2 = shouldHideBuyMob = this.room.getNbrMobs() >= this.room.getMaxMobs();
            if (shouldHideBuyMob != this.mobButton.isHidden()) {
                this.mobButton.setHidden(shouldHideBuyMob);
            }
        }
    }

    public Room getRoom() {
        return this.room;
    }

    public void onClicked(VillainGameWorld world, Button button) {
        if (this.room != null) {
            if (button == this.upgradeButton) {
                if (this.room.getUpgradeLevel() < this.room.getMaxLevel() && world.getBoss().deductCash(this.room.getUpgradePrice())) {
                    this.room.upgrade();
                }
            } else if (button == this.mobButton) {
                if (this.room.getNbrMobs() < this.room.getMaxMobs() && world.getBoss().deductCash(this.room.getNextMobPrice())) {
                    this.room.addMob();
                }
            } else {
                throw new RuntimeException("Unknown button.");
            }
        }
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        if (this.room != null) {
            super.render(g, world, container);
        }
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        if (this.room != null && !event.consumed() && event.type() == MouseEvent.Type.click && ((MouseClickEvent)event).rightClick()) {
            this.coordinator.deselect();
            event.consume();
        }
    }

    public void onSelectionChanged(Entity entity) {
        if (entity instanceof Room) {
            if (entity != null && entity != this.room) {
                entity.playAudio("default", 0.5f);
            }
            this.room = (Room)entity;
        } else {
            this.room = null;
        }
    }

    public BoundingBox getBounds() {
        return this.room == null ? null : super.getBounds();
    }

    private class Button
    extends UIComponent {
        private static final float BUTTON_SCALE = 1.0f;
        private Animation icon;
        private boolean hidden;

        public Button(Animation icon) {
            super(0.0f, 0.0f, (float)icon.getWidth() * 1.0f, (float)icon.getHeight() * 1.0f);
            this.icon = icon;
        }

        public void render(Graphics g, VillainGameWorld world, GameContainer container) {
            if (this.hidden) {
                return;
            }
            super.render(g, world, container);
            g.scale(1.0f, 1.0f);
            g.drawAnimation(this.icon, 0.0f, 0.0f);
        }

        public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
            if (this.hidden) {
                return;
            }
            super.handleMouseEvent(world, event);
            if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.click && ((MouseClickEvent)event).leftClick()) {
                RoomSelection.this.onClicked(world, this);
                event.consume();
            }
        }

        public void update(int dt, VillainGameWorld world, GameContainer container) {
            if (this.hidden) {
                return;
            }
            super.update(dt, world, container);
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }
}

