/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.util.EntitySelectionHandler;
import game.world.VillainGameWorld;
import java.util.ArrayList;
import org.newdawn.slick.GameContainer;

public class SelectionCoordinator
extends Entity {
    ArrayList<EntitySelectionHandler> handlers = new ArrayList();
    private Entity selected;

    public SelectionCoordinator(EntityDescriptor descriptor) {
        super(descriptor);
    }

    public void addHandler(EntitySelectionHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(EntitySelectionHandler handler) {
        this.handlers.remove(handler);
    }

    public void setSelection(Entity entity) {
        this.selected = entity;
        for (EntitySelectionHandler handler : this.handlers) {
            handler.onSelectionChanged(entity);
        }
    }

    public void deselect() {
        this.setSelection(null);
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.selected != null && this.selected.isDestroyed()) {
            this.deselect();
        }
    }

    public Entity getSelection() {
        return this.selected;
    }
}

