/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Traverser;
import game.world.VillainGameWorld;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public abstract class Traversable
extends Entity {
    private int width;
    private int height;
    private Traversable previousTraversable;
    private Traversable nextTraversable;

    public Traversable(EntityDescriptor descriptor) {
        super(descriptor);
        this.width = descriptor.properties.getInt("width");
        this.height = descriptor.properties.getInt("height");
        this.previousTraversable = null;
        this.nextTraversable = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Traversable getPreviousTraversable() {
        return this.previousTraversable;
    }

    public void setPreviousTraversable(Traversable previousTraversable) {
        this.previousTraversable = previousTraversable;
    }

    public Traversable getNextTraversable() {
        return this.nextTraversable;
    }

    public void setNextTraversable(Traversable nextTraversable) {
        this.nextTraversable = nextTraversable;
    }

    public Vector2f getEntryPoint() {
        if (this.previousTraversable == null) {
            return this.getMidPoint();
        }
        return Traversable.findConnectingMidPoint(this, this.previousTraversable);
    }

    private static Vector2f findConnectingMidPoint(Traversable a, Traversable b) {
        BoundingBox ba = a.getBounds();
        BoundingBox bb = b.getBounds();
        Vector2f pa = a.getPos();
        Vector2f pb = b.getPos();
        Vector2f ret = new Vector2f();
        if (ba.getMinX(pa) == bb.getMaxX(pb)) {
            ret.x = ba.getMinX(pa);
            ret.y = Math.max(ba.getMinY(pa), bb.getMinY(pb)) + Math.min(ba.getMaxY(pa), bb.getMaxY(pb));
            ret.y /= 2.0f;
        } else if (ba.getMaxX(pa) == bb.getMinX(pb)) {
            ret.x = ba.getMaxX(pa);
            ret.y = Math.max(ba.getMinY(pa), bb.getMinY(pb)) + Math.min(ba.getMaxY(pa), bb.getMaxY(pb));
            ret.y /= 2.0f;
        } else if (ba.getMinY(pa) == bb.getMaxY(pb)) {
            ret.y = ba.getMinY(pa);
            ret.x = Math.max(ba.getMinX(pa), bb.getMinX(pb)) + Math.min(ba.getMaxX(pa), bb.getMaxX(pb));
            ret.x /= 2.0f;
        } else if (ba.getMaxY(pa) == bb.getMinY(pb)) {
            ret.y = ba.getMaxY(pa);
            ret.x = Math.max(ba.getMinX(pa), bb.getMinX(pb)) + Math.min(ba.getMaxX(pa), bb.getMaxX(pb));
            ret.x /= 2.0f;
        } else {
            throw new RuntimeException("Weird. The rooms aren't connecting properly.");
        }
        return ret;
    }

    public Vector2f getMidPoint() {
        BoundingBox bb = this.getBounds();
        Vector2f pos = this.getPos();
        return new Vector2f(bb.getCenterX(pos), bb.getCenterY(pos));
    }

    public Vector2f getExitPoint() {
        if (this.nextTraversable == null) {
            return this.getMidPoint();
        }
        return Traversable.findConnectingMidPoint(this, this.nextTraversable);
    }

    public void debug(Graphics g, VillainGameWorld world, GameContainer container) {
        super.debug(g, world, container);
        Vector2f[] vs = new Vector2f[]{this.getEntryPoint(), this.getMidPoint(), this.getExitPoint()};
        g.setColor(Color.yellow);
        for (int i = 0; i < vs.length - 1; ++i) {
            Vector2f a = vs[i];
            Vector2f b = vs[i + 1];
            g.drawLine(a.x, a.y, b.x, b.y);
        }
        for (Vector2f v : vs) {
            g.fillOval(v.x - 1.0f, v.y - 1.0f, 2.0f, 2.0f);
        }
    }

    public void onStartEntering(Traverser traverser) {
    }

    public void onFinishedEntering(Traverser traverser) {
    }

    public void onStartExiting(Traverser traverser) {
    }

    public void onFinishedExiting(Traverser traverser) {
    }
}

