/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.ui.UIContainer;
import game.world.VillainGameWorld;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Vector2f;

public class UserInterfacePane
extends Entity {
    private UIContainer root;

    public UserInterfacePane(EntityDescriptor descriptor) {
        super(descriptor);
        this.setPos(descriptor.properties.getFloat("x", 0.0f), descriptor.properties.getFloat("y", 0.0f));
        BoundingBox b = this.getBounds();
        float w = b == null ? 0.0f : b.getWidth();
        float h = b == null ? 0.0f : b.getHeight();
        this.root = new UIContainer(0.0f, 0.0f, w, h);
        this.root.setFont((Font)this.fonts.get("default"));
        this.customRendering = true;
    }

    public UIContainer getRootPane() {
        return this.root;
    }

    public Font getDefaultFont() {
        return (Font)this.fonts.get("default");
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        this.root.update(dt, world, container);
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        Vector2f cp = this.root.getPos();
        Vector2f cs = this.root.getSize();
        g.pushTransform();
        g.translate(cp.x, cp.y);
        boolean clip = this.root.clip();
        Rectangle oldClip = null;
        if (clip) {
            oldClip = g.getWorldClip();
            g.setWorldClip(0.0f, 0.0f, cs.x, cs.y);
        }
        this.root.render(g, world, container);
        if (clip) {
            g.setWorldClip(oldClip);
        }
        g.popTransform();
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        this.root.handleMouseEvent(world, event.localized(this.root.getPos().x, this.root.getPos().y, this.root.getSize().x, this.root.getSize().y, 1.0f));
    }
}

