/*
 * Decompiled with CFR 0.152.
 */
package game.entities;

import game.engine.BoundingBox;
import game.engine.input.MouseEvent;
import game.engine.loader.EntityDescriptor;
import game.entities.Entity;
import game.entities.Entrance;
import game.entities.Room;
import game.entities.SelectionCoordinator;
import game.entities.Traversable;
import game.util.AccessibilityMatrix;
import game.util.ConnectingRestriction;
import game.util.IntersectingRestriction;
import game.util.PlacementRestriction;
import game.util.Position;
import game.world.VillainGameWorld;
import java.util.Iterator;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class World
extends Entity {
    private static final Color ACCESSIBLE_TILE_LINE_COLOR = new Color(0.0f, 0.3f, 0.0f, 1.0f);
    private static final Color ACCESSIBLE_TILE_BACKGROUND_COLOR = new Color(0.0f, 0.3f, 0.0f, 0.3f);
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private Traversable lastTraversable;
    private VillainGameWorld gameWorld;
    private AccessibilityMatrix accessability = null;
    private Entrance entrance;
    private int entranceY;
    private int entranceX;
    private int wallWidth;
    private int topWidth;

    public World(EntityDescriptor descriptor) {
        super(descriptor);
        this.width = descriptor.properties.getInt("width");
        this.height = descriptor.properties.getInt("height");
        this.tileWidth = descriptor.properties.getInt("tilewidth");
        this.tileHeight = descriptor.properties.getInt("tileheight");
        this.wallWidth = descriptor.properties.getInt("wallwidth", 0);
        this.topWidth = descriptor.properties.getInt("topwidth", 0);
        this.entranceX = descriptor.properties.getInt("entrancex", 0);
        this.entranceY = descriptor.properties.getInt("entrancey", 0);
        this.bounds = new BoundingBox(this.width * this.tileWidth, this.height * this.tileHeight);
        this.lastTraversable = null;
        this.customRendering = true;
    }

    public void init(VillainGameWorld world) {
        super.init(world);
        this.gameWorld = world;
        this.entrance = (Entrance)world.getLoader().create("entrance");
        this.lastTraversable = this.entrance;
        this.entrance.setPos(this.entranceX * this.tileWidth, this.entranceY * this.tileHeight);
        world.getEntities().add(this.entrance);
    }

    public void destroy(VillainGameWorld world) {
        super.destroy(world);
        world.getEntities().remove(this.entrance);
    }

    public PlacementRestriction getPlacementRestriction() {
        Traversable traversable;
        int count = 0;
        for (traversable = this.lastTraversable; traversable != null; traversable = traversable.getPreviousTraversable()) {
            ++count;
        }
        PlacementRestriction[] intersectionRestrictions = new PlacementRestriction[count];
        PlacementRestriction[] connectingRestriction = new PlacementRestriction[count - 1];
        int i = 0;
        int j = 0;
        for (traversable = this.lastTraversable; traversable != null; traversable = traversable.getPreviousTraversable()) {
            Position pos = this.toPos(traversable.getPos());
            intersectionRestrictions[i] = new IntersectingRestriction(pos.x, pos.y, traversable.getWidth(), traversable.getHeight());
            if (traversable != this.lastTraversable) {
                connectingRestriction[j] = new ConnectingRestriction(pos.x, pos.y, traversable.getWidth(), traversable.getHeight());
                ++j;
            }
            ++i;
        }
        PlacementRestriction notIntersectingOldRooms = PlacementRestriction.not(PlacementRestriction.or(intersectionRestrictions));
        PlacementRestriction notConnectingOldRooms = PlacementRestriction.not(PlacementRestriction.or(connectingRestriction));
        PlacementRestriction notIntersectingLeftWall = PlacementRestriction.not(new IntersectingRestriction(0, 0, this.wallWidth, this.height));
        PlacementRestriction notIntersectingTopWall = PlacementRestriction.not(new IntersectingRestriction(0, 0, this.width, this.topWidth));
        Position pos = this.toPos(this.lastTraversable.getPos());
        ConnectingRestriction connectsToLast = new ConnectingRestriction(pos.x, pos.y, this.lastTraversable.getWidth(), this.lastTraversable.getHeight());
        return PlacementRestriction.and(connectsToLast, notIntersectingOldRooms, notConnectingOldRooms, notIntersectingLeftWall, notIntersectingTopWall);
    }

    public void placeRoom(VillainGameWorld world, Room room, Position pos) {
        this.gameWorld.getEntities().add(room);
        room.setPos(this.toWorld(pos));
        if (this.lastTraversable != null) {
            room.setPreviousTraversable(this.lastTraversable);
            this.lastTraversable.setNextTraversable(room);
        }
        Iterator i$ = world.getEntities().get((Entity)((Object)Entrance.class)).iterator();
        while (i$.hasNext()) {
            Entrance e = (Entrance)i$.next();
            e.trigger();
        }
        this.lastTraversable = room;
    }

    public Room createRoom(String roomType) {
        return (Room)this.gameWorld.getLoader().create(roomType);
    }

    public Vector2f toWorld(Position pos) {
        BoundingBox bb = this.getBounds();
        return new Vector2f(bb.getMinX(this.getPos()) + (float)(pos.x * this.tileWidth), bb.getMinY(this.getPos()) + (float)(pos.y * this.tileHeight));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Position toPosRounded(Vector2f worldPos) {
        BoundingBox bb = this.getBounds();
        int x = (int)((worldPos.x - bb.getMinX(this.getPos())) / (float)this.tileWidth + 0.5f);
        int y = (int)((worldPos.y - bb.getMinY(this.getPos())) / (float)this.tileHeight + 0.5f);
        return new Position(x, y);
    }

    public Position toPos(Vector2f worldPos) {
        BoundingBox bb = this.getBounds();
        int x = (int)((worldPos.x - bb.getMinX(this.getPos())) / (float)this.tileWidth);
        int y = (int)((worldPos.y - bb.getMinY(this.getPos())) / (float)this.tileHeight);
        return new Position(x, y);
    }

    public void setAccessability(Room room) {
        if (room == null) {
            this.accessability = null;
        } else {
            this.accessability = new AccessibilityMatrix(this.width, this.height);
            PlacementRestriction restriction = this.getPlacementRestriction();
            int w = room.getWidth();
            int h = room.getHeight();
            for (int i = 0; i <= this.width - w; ++i) {
                for (int j = 0; j <= this.height - h; ++j) {
                    if (!restriction.allowed(room, i, j)) continue;
                    for (int i2 = i; i2 < i + w; ++i2) {
                        for (int j2 = j; j2 < j + h; ++j2) {
                            this.accessability.set(i2, j2, true);
                        }
                    }
                }
            }
        }
    }

    public void debug(Graphics g, VillainGameWorld world, GameContainer container) {
        super.debug(g, world, container);
        BoundingBox bb = this.getBounds();
        float x = bb.getMinX(this.getPos());
        float y = bb.getMinY(this.getPos());
        float w = this.width * this.tileWidth;
        float h = this.height * this.tileHeight;
        g.setColor(new Color(0.3f, 0.3f, 0.3f, 1.0f));
        for (int i = 0; i <= this.width; ++i) {
            g.drawLine(i * this.tileWidth, 0.0f, i * this.tileWidth, h);
        }
        for (int j = 0; j <= this.height; ++j) {
            g.drawLine(0.0f, j * this.tileHeight, w, j * this.tileHeight);
        }
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        if (this.accessability != null) {
            Animation available = null;
            if (this.animations.contains("availableground")) {
                available = (Animation)this.animations.get("availableground");
            }
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    if (!this.accessability.get(i, j)) continue;
                    if (available == null) {
                        g.setColor(ACCESSIBLE_TILE_BACKGROUND_COLOR);
                        g.fillRect(i * this.tileWidth, j * this.tileHeight, this.tileWidth, this.tileHeight);
                        g.setColor(ACCESSIBLE_TILE_LINE_COLOR);
                        g.drawRect(i * this.tileWidth, j * this.tileHeight, this.tileWidth, this.tileHeight);
                        continue;
                    }
                    g.drawAnimation((Animation)this.animations.get("availableground"), i * this.tileWidth, j * this.tileHeight);
                }
            }
        }
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        if (!event.contained() && event.type() == MouseEvent.Type.click) {
            world.getEntities().getOne(SelectionCoordinator.class).deselect();
        }
    }
}

