/*
 * Decompiled with CFR 0.152.
 */
package game.ui;

import game.engine.input.MouseEvent;
import game.engine.input.MouseScrollEvent;
import game.ui.UIComponent;
import game.ui.UIContainer;
import game.world.VillainGameWorld;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class ScrollPane
extends UIComponent {
    private float speed;
    private float currentScroll;
    private UIContainer container;
    private boolean auto;
    private boolean end;

    public ScrollPane(float x, float y, float w, float h, float speed) {
        super(x, y, w, h);
        this.speed = speed;
        this.container = new UIContainer();
        this.container.parent = this;
        this.clip = true;
        this.auto = false;
        this.end = true;
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        g.pushTransform();
        g.translate(0.0f, -((int)this.currentScroll));
        this.container.render(g, world, container);
        g.popTransform();
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        this.container.update(dt, world, container);
        if (this.auto && this.end) {
            float max = this.container.getSize().y;
            max -= this.getSize().y;
            this.currentScroll = max = Math.max(0.0f, max);
        }
    }

    protected void internalPack() {
    }

    public UIContainer getContainer() {
        return this.container;
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        if (event.contained() && !event.consumed() && event.type() == MouseEvent.Type.scroll) {
            MouseScrollEvent scroll = (MouseScrollEvent)event;
            float max = this.container.getSize().y;
            max -= this.getSize().y;
            max = Math.max(0.0f, max);
            this.currentScroll = Math.min(max, Math.max(0.0f, this.currentScroll - (float)scroll.delta * this.speed));
            this.end = Math.abs(max - this.currentScroll) <= 5.0f;
            scroll.consume();
        }
        if (!event.consumed()) {
            this.container.handleMouseEvent(world, event.localized(0.0f, -this.currentScroll, this.container.getSize().x, this.container.getSize().y, 1.0f));
        }
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
        this.end = true;
    }
}

