/*
 * Decompiled with CFR 0.152.
 */
package game.ui;

import game.engine.input.MouseEvent;
import game.world.VillainGameWorld;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class UIComponent {
    protected final Vector2f pos;
    protected final Vector2f size;
    protected boolean clip;
    protected UIComponent parent;
    protected Font font;

    public UIComponent() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public UIComponent(Vector2f pos, Vector2f size) {
        this.pos = pos;
        this.size = size;
        this.clip = false;
        this.parent = null;
        this.font = null;
    }

    public UIComponent(float x, float y, float w, float h) {
        this(new Vector2f(x, y), new Vector2f(w, h));
    }

    public void setPos(Vector2f pos) {
        this.pos.set(pos);
    }

    public Vector2f getPos() {
        return this.pos;
    }

    public void setSize(Vector2f size) {
        this.size.set(size);
    }

    public Vector2f getSize() {
        return this.size;
    }

    public boolean clip() {
        return this.clip;
    }

    public void pack() {
        if (this.parent != null) {
            this.parent.pack();
        }
    }

    protected void internalPack() {
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
    }

    public Font getFont() {
        if (this.font == null && this.parent != null) {
            return this.parent.getFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
    }
}

