/*
 * Decompiled with CFR 0.152.
 */
package game.ui;

import game.engine.input.MouseEvent;
import game.ui.UIComponent;
import game.world.VillainGameWorld;
import java.util.ArrayList;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Vector2f;

public class UIContainer
extends UIComponent {
    private ArrayList<UIComponent> components = new ArrayList();
    private boolean dirty = false;

    public UIContainer() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public UIContainer(Vector2f pos, Vector2f size) {
        super(pos, size);
    }

    public UIContainer(float x, float y, float w, float h) {
        this(new Vector2f(x, y), new Vector2f(w, h));
    }

    public void addComponent(UIComponent component) {
        this.components.add(component);
        component.parent = this;
        this.dirty = true;
    }

    public void render(Graphics g, VillainGameWorld world, GameContainer container) {
        super.render(g, world, container);
        for (UIComponent component : this.components) {
            Vector2f cp = component.getPos();
            Vector2f cs = component.getSize();
            g.pushTransform();
            g.translate(cp.x, cp.y);
            boolean clip = component.clip();
            Rectangle oldClip = null;
            if (clip) {
                oldClip = g.getWorldClip();
                g.setWorldClip(0.0f, 0.0f, cs.x, cs.y);
            }
            component.render(g, world, container);
            if (clip) {
                g.setWorldClip(oldClip);
            }
            g.popTransform();
        }
    }

    public void update(int dt, VillainGameWorld world, GameContainer container) {
        super.update(dt, world, container);
        if (this.dirty) {
            this.pack();
        }
        for (UIComponent component : this.components) {
            component.update(dt, world, container);
        }
    }

    public void pack() {
        super.pack();
        UIComponent p = this;
        while (p != null) {
            ((UIComponent)p).internalPack();
            p = p.parent;
        }
        this.dirty = false;
    }

    protected void internalPack() {
        super.internalPack();
        Vector2f cs = this.getSize();
        cs.x = 0.0f;
        cs.y = 0.0f;
        for (UIComponent component : this.components) {
            float maxX = component.getPos().x + component.getSize().x;
            float maxY = component.getPos().y + component.getSize().y;
            if (maxX > cs.x) {
                cs.x = maxX;
            }
            if (!(maxY > cs.y)) continue;
            cs.y = maxY;
        }
    }

    public void handleMouseEvent(VillainGameWorld world, MouseEvent event) {
        super.handleMouseEvent(world, event);
        for (UIComponent c : this.components) {
            if (event.consumed()) break;
            c.handleMouseEvent(world, event.localized(c.getPos().x, c.getPos().y, c.getSize().x, c.getSize().y, 1.0f));
        }
    }
}

