/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.entities.Room;
import game.util.PlacementRestriction;

public class ConnectingRestriction
extends PlacementRestriction {
    private int xr;
    private int yr;
    private int wr;
    private int hr;

    public ConnectingRestriction(int x, int y, int w, int h) {
        this.xr = x;
        this.yr = y;
        this.wr = w;
        this.hr = h;
    }

    public boolean allowed(Room room, int x, int y) {
        int w = room.getWidth();
        int h = room.getHeight();
        boolean cx = this.connects(x, x + w, this.xr, this.xr + this.wr);
        boolean cy = this.connects(y, y + h, this.yr, this.yr + this.hr);
        boolean ix = this.intersects(x, x + w, this.xr, this.xr + this.wr);
        boolean iy = this.intersects(y, y + h, this.yr, this.yr + this.hr);
        return cx && iy || cy && ix;
    }

    private boolean connects(int a1, int a2, int b1, int b2) {
        return a1 == b2 || a2 == b1;
    }

    private boolean intersects(int a1, int a2, int b1, int b2) {
        if (a2 <= b1) {
            return false;
        }
        return a1 < b2;
    }
}

