/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.util.HeroDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeroDescriptorGenerator {
    private static final float BASE_STRENGTH = 40.0f;
    private static final float DELTA_STRENGTH = 0.5f;
    private static final float DELTA_DEFENSE = 0.25f;
    private static final float BASE_HP = 100.0f;
    private static final float DELTA_HP = 1.2f;
    private static final int BASE_LOOT = 30;
    private static final int DELTA_LOOT = 5;
    private Random random;
    private int generatedHeroes;
    ArrayList<String> prefixes;
    ArrayList<String> names;
    ArrayList<String> epithets;
    ArrayList<String> verbs;
    ArrayList<String> nouns;

    public HeroDescriptorGenerator(Random random) {
        this.random = random;
        this.prefixes = new ArrayList();
        this.names = new ArrayList();
        this.epithets = new ArrayList();
        this.verbs = new ArrayList();
        this.nouns = new ArrayList();
        this.readTextFiles();
    }

    public HeroDescriptor generateDescriptor() {
        HeroDescriptor heroDescriptor = new HeroDescriptor();
        HeroType[] heroTypes = HeroType.values();
        int nbrTypes = heroTypes.length;
        float invNbrTypes = 1.0f / (float)nbrTypes;
        float randomNumber = this.random.nextFloat();
        for (int i = 0; i < nbrTypes; ++i) {
            if (!(randomNumber <= (float)i * invNbrTypes)) continue;
            heroTypes[i].setHeroResistances(heroDescriptor, this.random);
            break;
        }
        heroDescriptor.strength = 40.0f + (float)this.generatedHeroes * 0.5f;
        heroDescriptor.startingHitpoints = 100.0f + (float)this.generatedHeroes * 1.2f;
        heroDescriptor.lootAmount = 30 + this.generatedHeroes * 5;
        heroDescriptor.defense = (float)this.generatedHeroes * 0.25f;
        heroDescriptor.successionNumber = this.generatedHeroes++;
        heroDescriptor.consoleName = this.pickRandomListEntry(this.prefixes) + this.pickRandomListEntry(this.names);
        heroDescriptor.fullHeroName = heroDescriptor.consoleName + this.pickRandomListEntry(this.epithets);
        heroDescriptor.factText0 = this.pickRandomListEntry(this.verbs) + this.pickRandomListEntry(this.nouns);
        return heroDescriptor;
    }

    private String pickRandomListEntry(ArrayList<String> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private void readTextFiles() {
        this.readFile("prefixes", this.prefixes);
        this.readFile("names", this.names);
        this.readFile("epithets", this.epithets);
        this.readFile("verbs", this.verbs);
        this.readFile("nouns", this.nouns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String fileName, ArrayList<String> list) {
        String fullPath = "/assets/text/" + fileName + ".txt";
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(fullPath)));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HeroType {
        LAVA_HERO(7.0f, 3.0f, 1.5f, 1.5f, 0.5f, 0.0f),
        SPIKE_HERO(10.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f),
        ELECTRICITY_HERO(8.0f, 3.5f, 1.0f, 1.0f, 0.5f, 1.0f),
        HAUNTED_HERO(15.0f, 0.2f, 0.2f, 0.4f, 0.5f, 0.2f),
        SAW_HERO(10.0f, 1.0f, 1.0f, 1.0f, 1.0f, 5.0f);

        private static final float BASE_RESISTANCE = 3.0f;
        float baseStatBonus;
        float lavaResistanceVariance;
        float spikeResistanceVariance;
        float electricityResistanceVariance;
        float hauntedResistanceVariance;
        float sawResistanceVariance;

        private HeroType(float base, float lava, float spike, float electricity, float haunted, float saw) {
            this.baseStatBonus = base;
            this.lavaResistanceVariance = lava;
            this.spikeResistanceVariance = spike;
            this.electricityResistanceVariance = electricity;
            this.hauntedResistanceVariance = haunted;
            this.sawResistanceVariance = saw;
        }

        private void setHeroResistances(HeroDescriptor heroDescriptor, Random random) {
            heroDescriptor.setAllResistancesTo(3.0f);
            heroDescriptor.lavaResistance += this.lavaResistanceVariance * (random.nextFloat() * 2.0f - 1.0f);
            heroDescriptor.spikeResistance += this.spikeResistanceVariance * (random.nextFloat() * 2.0f - 1.0f);
            heroDescriptor.electricityResistance += this.electricityResistanceVariance * (random.nextFloat() * 2.0f - 1.0f);
            heroDescriptor.hauntedResistance += this.hauntedResistanceVariance * (random.nextFloat() * 2.0f - 1.0f);
            heroDescriptor.sawResistance += this.sawResistanceVariance * (random.nextFloat() * 2.0f - 1.0f);
            switch (this) {
                case LAVA_HERO: {
                    heroDescriptor.lavaResistance += this.baseStatBonus;
                    break;
                }
                case SPIKE_HERO: {
                    heroDescriptor.spikeResistance += this.baseStatBonus;
                    break;
                }
                case ELECTRICITY_HERO: {
                    heroDescriptor.electricityResistance += this.baseStatBonus;
                    break;
                }
                case HAUNTED_HERO: {
                    heroDescriptor.hauntedResistance += this.baseStatBonus;
                    break;
                }
                case SAW_HERO: {
                    heroDescriptor.sawResistance += this.baseStatBonus;
                }
            }
        }
    }
}

