/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.entities.Room;
import game.util.PlacementRestriction;

public class IntersectingRestriction
extends PlacementRestriction {
    private int xr;
    private int yr;
    private int wr;
    private int hr;

    public IntersectingRestriction(int x, int y, int w, int h) {
        this.xr = x;
        this.yr = y;
        this.wr = w;
        this.hr = h;
    }

    public boolean allowed(Room room, int x, int y) {
        int w = room.getWidth();
        int h = room.getHeight();
        boolean ix = this.intersects(x, x + w, this.xr, this.xr + this.wr);
        boolean iy = this.intersects(y, y + h, this.yr, this.yr + this.hr);
        return ix && iy;
    }

    private boolean intersects(int a1, int a2, int b1, int b2) {
        if (a2 <= b1) {
            return false;
        }
        return a1 < b2;
    }
}

