/*
 * Decompiled with CFR 0.152.
 */
package game.util;

import game.entities.Room;

public abstract class PlacementRestriction {
    public static final PlacementRestriction ANY = new PlacementRestriction(){

        public boolean allowed(Room room, int x, int y) {
            return true;
        }
    };
    public static final PlacementRestriction NONE = new PlacementRestriction(){

        public boolean allowed(Room room, int x, int y) {
            return false;
        }
    };

    public static PlacementRestriction and(final PlacementRestriction ... restrictions) {
        return new PlacementRestriction(){

            public boolean allowed(Room room, int x, int y) {
                for (PlacementRestriction restriction : restrictions) {
                    if (restriction.allowed(room, x, y)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static PlacementRestriction or(final PlacementRestriction ... restrictions) {
        return new PlacementRestriction(){

            public boolean allowed(Room room, int x, int y) {
                for (PlacementRestriction restriction : restrictions) {
                    if (!restriction.allowed(room, x, y)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static PlacementRestriction not(final PlacementRestriction restriction) {
        return new PlacementRestriction(){

            public boolean allowed(Room room, int x, int y) {
                return !restriction.allowed(room, x, y);
            }
        };
    }

    public abstract boolean allowed(Room var1, int var2, int var3);
}

