/*
 * Decompiled with CFR 0.152.
 */
package game.world;

import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.input.MouseEvent;
import game.engine.input.MouseManager;
import game.engine.loader.EntityLoader;
import game.engine.util.ObjectListener;
import game.engine.util.ObjectManager;
import game.entities.Boss;
import game.entities.CharacterSelection;
import game.entities.Console;
import game.entities.Entity;
import game.entities.Entrance;
import game.entities.Hero;
import game.entities.InformationBox;
import game.entities.Room;
import game.entities.RoomCursor;
import game.entities.RoomSelection;
import game.entities.SelectionCoordinator;
import game.entities.World;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VillainGameWorld {
    private boolean debug;
    private Random random = new Random();
    private EntityLoader loader;
    private GameCamera camera;
    private ObjectManager<Entity> objects;
    private MouseManager mouseManager;

    public VillainGameWorld(EntityLoader loader) {
        this.loader = loader;
        this.camera = new GameCamera();
        this.debug = false;
        this.objects = new ObjectManager<Entity>(Entity.class);
        this.objects.installTypeMapping(World.class);
        this.objects.installTypeMapping(Room.class);
        this.objects.installTypeMapping(RoomCursor.class);
        this.objects.installTypeMapping(Entrance.class);
        this.objects.installTypeMapping(Hero.class);
        this.objects.installTypeMapping(Console.class);
        this.objects.installTypeMapping(RoomSelection.class);
        this.objects.installTypeMapping(CharacterSelection.class);
        this.objects.installTypeMapping(SelectionCoordinator.class);
        this.objects.installTypeMapping(InformationBox.class);
        this.objects.installTypeMapping(Entrance.class);
        this.objects.addListener(new ObjectListener<Entity>(){

            @Override
            public void onAdd(Entity object) {
                object.init(VillainGameWorld.this);
            }

            @Override
            public void onRemove(Entity object) {
                object.destroy(VillainGameWorld.this);
            }
        });
    }

    public void init(GameContainer container) {
        this.mouseManager = new MouseManager(container.getInput());
        this.camera.init(container.getWidth(), container.getHeight());
        this.camera.setScale(2.0f);
        this.objects.add(this.loader.create("world"));
        this.objects.add(this.loader.create("console"));
        this.objects.add(this.loader.create("buildmenu"));
        this.objects.add(this.loader.create("infobox"));
        this.objects.add(this.loader.create("selectioncoordinator"));
        this.objects.add(this.loader.create("roomselection"));
        this.objects.add(this.loader.create("characterselection"));
    }

    public void update(int dt, GameContainer container) {
        if (container.getInput().isKeyPressed(88)) {
            this.debug = !this.debug;
        }
        List<Entity> objs = this.objects.get();
        Collections.sort(objs, new RenderComparator());
        Collections.reverse(objs);
        BoundingBox emptyBounds = new BoundingBox(0.0f, 0.0f);
        block0: for (MouseEvent event : this.mouseManager.takeEvents()) {
            if (event.consumed()) continue;
            BoundingBox bb = this.getCamera().getScreenBounds();
            Vector2f v = this.getCamera().getScreenPos();
            event = event.localized(-bb.getMinX(v), -bb.getMinY(v), bb.getWidth(), bb.getHeight(), this.getCamera().getScale());
            for (Entity o : objs) {
                if (event.consumed()) continue block0;
                bb = o.getBounds();
                v = o.getPos();
                if (bb == null) {
                    bb = emptyBounds;
                }
                o.handleMouseEvent(this, event.localized(bb.getMinX(v), bb.getMinY(v), bb.getWidth(), bb.getHeight(), o.getScale()));
            }
        }
        this.camera.update(this, dt);
        for (Entity o : this.objects.get()) {
            o.update(dt, this, container);
        }
    }

    public void render(Graphics g, GameContainer container) {
        g.pushTransform();
        this.camera.applyTransform(g, container);
        g.pushTransform();
        List<Entity> objs = this.objects.get();
        Collections.sort(objs, new RenderComparator());
        for (Entity o : objs) {
            g.pushTransform();
            if (o.preRender(g, this, container)) {
                o.render(g, this, container);
                o.postRender(g, this, container);
            }
            g.popTransform();
        }
        if (this.debug) {
            g.setFont(container.getDefaultFont());
            for (Entity o : objs) {
                o.debug(g, this, container);
            }
        }
        g.popTransform();
        g.popTransform();
        if (this.debug) {
            g.pushTransform();
            g.setFont(container.getDefaultFont());
            g.translate((float)container.getWidth() - 200.0f, 0.0f);
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.8f));
            g.fillRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.black);
            g.drawRect(0.0f, 0.0f, 200.0f, 300.0f);
            g.setColor(Color.white);
            g.drawString("Debug overlay", 0.0f, 0.0f);
            g.translate(0.0f, g.getFont().getLineHeight());
            g.scale(0.75f, 0.75f);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Entity count: %d\n", this.objects.size()));
            g.drawString(sb.toString(), 0.0f, 0.0f);
            g.popTransform();
        }
    }

    public void println(String format, Object ... args) {
        this.println(Console.MessageColor.TEXT, format, args);
    }

    public void println(Console.MessageColor color, String format, Object ... args) {
        Console console = this.objects.getOne(Console.class);
        String text = String.format(format, args);
        console.addLine(text, color);
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public Boss getBoss() {
        return this.objects.getOne(Boss.class);
    }

    public World getWorld() {
        return this.objects.getOne(World.class);
    }

    public RoomCursor getCursor() {
        return this.objects.getOne(RoomCursor.class);
    }

    public Random getRandom() {
        return this.random;
    }

    public EntityLoader getLoader() {
        return this.loader;
    }

    public ObjectManager<Entity> getEntities() {
        return this.objects;
    }

    public boolean isGameOver() {
        return this.getBoss() == null || this.getBoss().isDestroyed() || this.getBoss().getState() == Boss.State.dead;
    }

    public boolean isVictorious() {
        return this.objects.getOne(Entrance.class).finished() && this.objects.get((Entity)((Object)Hero.class)).isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenderComparator
    implements Comparator<Entity> {
        private RenderComparator() {
        }

        @Override
        public int compare(Entity a, Entity b) {
            return a.compareRenderOrder(b);
        }
    }
}

