/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.entities.Boss;
import game.entities.GameDoor;
import game.entities.NPC;
import game.entities.Player;
import game.entities.Projectile;
import game.entities.WallSocket;
import game.entities.visitor.GamePairDispatcher;
import game.map.GameMap;
import game.world.GameWorld;

public class CollisionHandler
extends GamePairDispatcher {
    private GameWorld world;

    public CollisionHandler(GameWorld world) {
        this.world = world;
    }

    public void handle(Player a, GameDoor b) {
    }

    public void handle(NPC a, GameDoor b) {
    }

    public void handle(Projectile a, GameDoor b) {
    }

    public void handle(WallSocket a, GameDoor b) {
    }

    public void handle(GameDoor a, GameDoor b) {
    }

    public void handle(Player a, Boss b) {
    }

    public void handle(NPC a, Boss b) {
    }

    public void handle(Projectile a, Boss b) {
        if (a.isMoving() && a.getTarget() == Projectile.Target.enemy && a.isActive()) {
            b.takeDMG(this.world, a.getProjectilePower(), a.getForward());
            a.playAudio("hit_npc");
            this.world.getEntities().remove(a);
            if (a.getGroup() != null) {
                a.getGroup().setActive(false);
            }
        }
    }

    public void handle(WallSocket a, Boss b) {
    }

    public void handle(GameDoor a, Boss b) {
    }

    public void handle(Boss a, Boss b) {
    }

    public void handle(Player a, Player b) {
    }

    public void handle(Player a, NPC b) {
        if (b.isTimeToHurt()) {
            a.takeDMG(this.world, 15, b.getForward());
            b.resetHurtTimer();
        }
    }

    public void handle(Player a, Projectile b) {
        if (b.isMoving() && b.getTarget() == Projectile.Target.player && b.isActive()) {
            a.takeDMG(this.world, b.getProjectilePower(), b.getForward());
            a.knockback(b.getForward());
            b.playAudio("hit_npc");
            this.world.getEntities().remove(b);
            if (b.getGroup() != null) {
                b.getGroup().setActive(false);
            }
        }
    }

    public void handle(Player a, WallSocket b) {
    }

    public void handle(NPC a, NPC b) {
    }

    public void handle(NPC a, Projectile b) {
        if (b.isMoving() && b.getTarget() == Projectile.Target.enemy) {
            a.takeDMG(this.world, b.getProjectilePower(), b.getForward());
            a.knockback(b.getForward());
            b.playAudio("hit_npc");
            this.world.getEntities().remove(b);
        }
    }

    public void handle(NPC a, WallSocket b) {
    }

    public void handle(Projectile a, Projectile b) {
    }

    public void handle(Projectile a, WallSocket b) {
    }

    public void handle(WallSocket a, WallSocket b) {
    }

    public void handle(GameMap a, Player b) {
    }

    public void handle(GameMap a, NPC b) {
    }

    public void handle(GameMap a, Projectile b) {
    }

    public void handle(GameMap a, WallSocket b) {
    }

    public void handle(GameMap a, GameDoor b) {
    }

    public void handle(GameMap world, Boss boss) {
    }
}

