/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MolyJamGame;
import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.Updateable;
import game.objects.NPC;
import java.util.Set;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Vector2f;

public class HardNightmareSpawner
implements Updateable {
    private static final int TIME_UNIT = 3000;
    private static final int CREATE_PER_TIME_UNIT = 5;
    private static final float SPAWN_PERCENTAGE_PER_TIME_UNIT = 0.07f;
    private static final int MAX_STORED_NIGHTMARES = 100;
    private int storedNightmares = 50;
    private boolean connectedToSocket;
    private int tick;

    public void init(MolyJamGame jam, GameContainer container) {
    }

    public void update(MolyJamGame jam, GameContainer container, int dt) {
        if (jam.getPlayer().getSocket() == null && this.connectedToSocket) {
            this.connectedToSocket = false;
            this.tick = 0;
        } else if (jam.getPlayer().getSocket() != null && !this.connectedToSocket) {
            this.connectedToSocket = true;
            this.tick = 0;
        }
        this.tick += dt;
        if (this.tick >= 3000) {
            this.tick = 0;
            if (!this.connectedToSocket) {
                this.updateDisconnected();
            }
            this.updateConnected(jam);
        }
    }

    public void render(MolyJamGame jam, GameContainer container, Graphics graphic) {
    }

    private void updateDisconnected() {
        if (this.storedNightmares < 100) {
            this.storedNightmares += 5;
        }
    }

    private void updateConnected(MolyJamGame jam) {
        if (this.storedNightmares <= 0) {
            return;
        }
        int spawnNbr = (int)(0.07f * (float)this.storedNightmares);
        this.storedNightmares -= spawnNbr;
        if (this.storedNightmares < 0) {
            this.storedNightmares = 0;
        }
        Vector2f playerPos = jam.getPlayer().getPos();
        GameCamera camera = jam.getCamera();
        BoundingBox screenBounds = camera.getScreenBounds();
        Vector2f screenPos = camera.getScreenPos();
        Set spawnLocations = jam.getWorld().findSpawnablePositions(playerPos, screenBounds, screenPos, spawnNbr, jam);
        NPC.NPCTypes[] npcTypeValues = NPC.NPCTypes.values();
        int nbrTypes = npcTypeValues.length;
        int currType = 0;
        for (Vector2f loc : spawnLocations) {
            NPC newEnemy = (NPC)jam.getObjectLoader().createObject(npcTypeValues[currType++].name());
            newEnemy.setPos(loc.x, loc.y);
            jam.addGameObject(newEnemy);
            currType %= nbrTypes;
        }
    }
}

