/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MollysNightmareState;
import game.engine.util.ImageUtil;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MollysNightmareEnd
extends BasicGameState {
    private EndingOption endingOption;
    private TitleState state;
    private int containerWidth;
    private Image goodEnding;
    private Image badEnding;
    private Image goodEndingImage;
    private Image goodEndingSelectedImage;
    private Image badEndingImage;
    private Image badEndingSelectedImage;
    private Sound sound;
    private Image titleEnding;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.state = TitleState.menuEnding;
        this.endingOption = EndingOption.good;
        this.containerWidth = container.getWidth();
        try {
            this.goodEndingImage = ImageUtil.load("/assets/graphics/g_end_button.png");
            this.goodEndingSelectedImage = ImageUtil.load("/assets/graphics/g_end_button_s.png");
            this.badEndingImage = ImageUtil.load("/assets/graphics/b_end_button.png");
            this.badEndingSelectedImage = ImageUtil.load("/assets/graphics/b_end_button_s.png");
            this.goodEnding = ImageUtil.load("/assets/graphics/good_ending.png");
            this.badEnding = ImageUtil.load("/assets/graphics/bad_ending.png");
            this.titleEnding = ImageUtil.load("/assets/graphics/choose_ending.png");
            this.sound = new Sound("/assets/audio/menuEffect1.wav");
        }
        catch (SlickException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.state = TitleState.menuEnding;
        this.endingOption = EndingOption.good;
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.state == TitleState.menuEnding) {
            if (container.getInput().isKeyPressed(28)) {
                container.getInput().clearKeyPressedRecord();
                switch (this.endingOption) {
                    case good: {
                        this.state = TitleState.goodEnding;
                        this.sound.play();
                        return;
                    }
                    case bad: {
                        this.state = TitleState.badEnding;
                        this.sound.play();
                        return;
                    }
                }
            } else if (container.getInput().isKeyPressed(208)) {
                int i = Math.min(EndingOption.values().length - 1, this.endingOption.ordinal() + 1);
                this.endingOption = EndingOption.values()[i];
                this.sound.play();
            } else if (container.getInput().isKeyPressed(200)) {
                int i = Math.max(0, this.endingOption.ordinal() - 1);
                this.endingOption = EndingOption.values()[i];
                this.sound.play();
            }
        } else if (this.state == TitleState.goodEnding) {
            if (container.getInput().isKeyPressed(28)) {
                this.sound.play();
                game.enterState(MollysNightmareState.title.ordinal());
            }
        } else if (this.state == TitleState.badEnding && container.getInput().isKeyPressed(28)) {
            this.sound.play();
            game.enterState(MollysNightmareState.title.ordinal());
        }
    }

    public void setState(TitleState state) {
        this.state = state;
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.pushTransform();
        g.scale(2.0f, 2.0f);
        if (this.state == TitleState.menuEnding) {
            int titleHeight = 150;
            int buttonWidth = this.goodEndingImage.getWidth();
            int buttonHeight = this.goodEndingImage.getHeight();
            this.titleEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
            switch (this.endingOption) {
                case good: {
                    g.drawImage(this.goodEndingSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    g.drawImage(this.badEndingImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    break;
                }
                case bad: {
                    g.drawImage(this.goodEndingImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    g.drawImage(this.badEndingSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                }
            }
        } else if (this.state == TitleState.goodEnding) {
            this.goodEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        } else if (this.state == TitleState.badEnding) {
            this.badEnding.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        }
        g.popTransform();
    }

    public int getID() {
        return MollysNightmareState.end.ordinal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EndingOption {
        good,
        bad;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleState {
        menuEnding,
        goodEnding,
        badEnding;

    }
}

