/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.CollisionHandler;
import game.MollysNightmare;
import game.MollysNightmareState;
import game.engine.BoundingBox;
import game.engine.loader.EntityLoader;
import game.engine.util.ImageUtil;
import game.entities.Boss;
import game.entities.BossDoor;
import game.entities.Entity;
import game.entities.GameDoor;
import game.entities.NPC;
import game.entities.ParticleSystemEntity;
import game.entities.Player;
import game.entities.Projectile;
import game.entities.TimedDoor;
import game.entities.WallSocket;
import game.entities.visitor.Visitor;
import game.map.GameMap;
import game.map.MapObject;
import game.world.GameWorld;
import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.tiled.TiledMap;

public class MollysNightmareGame
extends BasicGameState {
    private static final String[] levelFiles = new String[]{"/assets/levels/level1.tmx", "/assets/levels/level2.tmx", "/assets/levels/arena.tmx"};
    private SpriteSheet powerSheet;
    private SpriteSheet sanitySheet;
    private Image gameOverImage;
    private int levelIndex;
    private GameWorld world;
    private EntityLoader loader;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.levelIndex = 0;
        Image powerImage = ImageUtil.load("/assets/graphics/power_sheet.png");
        Image sanityImage = ImageUtil.load("/assets/graphics/sanity_sheet.png");
        this.powerSheet = new SpriteSheet(powerImage, 64, 64);
        this.sanitySheet = new SpriteSheet(sanityImage, 64, 64);
        this.gameOverImage = ImageUtil.load("/assets/graphics/game_over_screen.png");
        this.loader = new EntityLoader("/assets/xml");
        this.initLevel(container, levelFiles[0]);
    }

    private void initLevel(GameContainer container, String level) throws SlickException {
        GameMap map = new GameMap(new TiledMap(this.getClass().getResourceAsStream(level), "/assets/levels"));
        this.world = new GameWorld(this.loader, map);
        this.world.getCamera().setScale(2.0f);
        this.world.getCamera().init(container.getWidth(), container.getHeight());
        this.initMapObjects(map);
        this.world.getEntities().add(this.loader.create("nightmarespawner"));
        this.world.getEntities().installTypeMapping(ParticleSystemEntity.class);
        this.world.getEntities().add(this.loader.create("particlesystem"));
    }

    private void initMapObjects(GameMap map) {
        HashMap<String, Entity> namedObjects = new HashMap<String, Entity>();
        HashMap<String, ArrayList<GameDoor>> doorMap = new HashMap<String, ArrayList<GameDoor>>();
        for (MapObject object : map.getObjects()) {
            ArrayList<GameDoor> tmp;
            BoundingBox dbb;
            Vector2f p;
            GameDoor door;
            BoundingBox rect;
            BoundingBox bb;
            BoundingBox rect2;
            if (object.isTypeOrName("spawn")) {
                Player player = (Player)this.loader.create("player");
                rect2 = object.getRectangle();
                player.setPos(rect2.getCenterX(0.0f, 0.0f), rect2.getCenterY(0.0f, 0.0f));
                this.world.getEntities().add(player);
                this.world.getCamera().attach(player);
                continue;
            }
            if (object.isTypeOrName("goal")) {
                this.world.getMap().setGoalBounds(object.getRectangle());
                continue;
            }
            if (object.getType().equalsIgnoreCase("npc")) {
                String npcName = object.getName().toLowerCase();
                NPC npc = (NPC)this.loader.create(npcName);
                bb = npc.getBoundingBox();
                rect = object.getRectangle();
                npc.setPos(rect.getCenterX(0.0f, 0.0f) - bb.getCenterX(0.0f, 0.0f), rect.getCenterY(0.0f, 0.0f) - bb.getCenterY(0.0f, 0.0f));
                this.world.getEntities().add(npc);
                continue;
            }
            if (object.isTypeOrName("wallsocket")) {
                WallSocket socket = (WallSocket)this.loader.create("outlet");
                rect2 = object.getRectangle();
                try {
                    int doorTimer = Integer.parseInt(object.getProperty("timer", ""));
                    socket.setDoorTimer(doorTimer);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                socket.setPos(rect2.getMinX(0.0f, 0.0f) + 8.0f, rect2.getMinY(0.0f, 0.0f) + 8.0f);
                this.world.getEntities().add(socket);
                String objectName = object.getProperty("name", "");
                if (objectName.isEmpty()) continue;
                namedObjects.put(objectName, socket);
                continue;
            }
            if (object.isTypeOrName("verticaldoor") || object.isTypeOrName("horizontaldoor")) {
                door = object.isTypeOrName("verticaldoor") ? (TimedDoor)this.loader.create("verticaldoor") : (TimedDoor)this.loader.create("horizontaldoor");
                rect2 = object.getRectangle();
                p = map.alignPosition(new Vector2f(rect2.getCenterX(0.0f, 0.0f), rect2.getCenterY(0.0f, 0.0f)));
                dbb = door.getBoundingBox();
                door.setPos(p.x - dbb.getCenterX(0.0f, 0.0f), p.y - dbb.getCenterY(0.0f, 0.0f));
                this.world.getEntities().add(door);
                String socketName = object.getProperty("socket", "");
                if (socketName.isEmpty()) continue;
                tmp = (ArrayList<GameDoor>)doorMap.get(socketName);
                if (tmp == null) {
                    tmp = new ArrayList<GameDoor>();
                    doorMap.put(socketName, tmp);
                }
                tmp.add(door);
                continue;
            }
            if (object.isTypeOrName("verticalbossdoor") || object.isTypeOrName("horizontalbossdoor")) {
                door = object.isTypeOrName("verticalbossdoor") ? (BossDoor)this.loader.create("verticalbossdoor") : (BossDoor)this.loader.create("horizontalbossdoor");
                rect2 = object.getRectangle();
                p = map.alignPosition(new Vector2f(rect2.getCenterX(0.0f, 0.0f), rect2.getCenterY(0.0f, 0.0f)));
                dbb = door.getBoundingBox();
                door.setPos(p.x - dbb.getCenterX(0.0f, 0.0f), p.y - dbb.getCenterY(0.0f, 0.0f));
                this.world.getEntities().add(door);
                String bossName = object.getProperty("boss", "");
                if (bossName.isEmpty()) continue;
                tmp = (ArrayList<GameDoor>)doorMap.get(bossName);
                if (tmp == null) {
                    tmp = new ArrayList<GameDoor>();
                    doorMap.put(bossName, tmp);
                }
                tmp.add(door);
                continue;
            }
            if (object.isTypeOrName("boss")) {
                String name = object.getName().toLowerCase();
                Boss boss = (Boss)this.loader.create(name);
                bb = boss.getBoundingBox();
                rect = object.getRectangle();
                boss.setPos(rect.getCenterX(0.0f, 0.0f) - bb.getCenterX(0.0f, 0.0f), rect.getCenterY(0.0f, 0.0f) - bb.getCenterY(0.0f, 0.0f));
                this.world.getEntities().add(boss);
                String objectName = object.getProperty("name", "");
                if (objectName.isEmpty()) continue;
                namedObjects.put(objectName, boss);
                continue;
            }
            System.out.println("WARNING: Unknown map object type " + object.getType() + ".");
        }
        for (String linkedName : doorMap.keySet()) {
            Entity linkedObject = (Entity)namedObjects.get(linkedName);
            if (linkedObject != null) {
                ArrayList doors = (ArrayList)doorMap.get(linkedName);
                for (GameDoor door : doors) {
                    if (door instanceof TimedDoor) {
                        TimedDoor tdoor = (TimedDoor)door;
                        WallSocket socket = (WallSocket)linkedObject;
                        tdoor.setSocket(socket);
                        int doorTimer = socket.getDoorTimer();
                        if (doorTimer <= 0) continue;
                        tdoor.setDoorTimer(doorTimer);
                        continue;
                    }
                    if (!(door instanceof BossDoor)) continue;
                    BossDoor bdoor = (BossDoor)door;
                    Boss boss = (Boss)linkedObject;
                    bdoor.setBoss(boss);
                }
                continue;
            }
            System.out.println("WARNING: Linked object for door not found. \"" + linkedName + "\".");
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.pushTransform();
        this.world.render(g, container);
        g.popTransform();
        Player player = this.world.getPlayer();
        if (player != null && !player.isDead()) {
            g.pushTransform();
            g.scale(2.0f, 2.0f);
            int healthStepSize = 20;
            int sanityId = Math.max(0, Math.min(player.getHealth() / healthStepSize, 4));
            int powerId = 0;
            if (player.getSocket() != null) {
                int powerStepSize = 20;
                powerId = player.getSocket().getCharge() == 0 ? 1 : Math.max(0, Math.min(player.getSocket().getCharge() / powerStepSize, 4)) + 2;
            }
            Image currentSanity = this.sanitySheet.getSprite(4 - sanityId, 0);
            currentSanity.draw(0.0f, (float)container.getHeight() / 2.0f - (float)currentSanity.getHeight());
            Image currentPower = this.powerSheet.getSprite(powerId, 0);
            currentPower.draw((float)container.getWidth() / 2.0f - (float)currentPower.getWidth(), (float)container.getHeight() / 2.0f - (float)currentPower.getHeight());
            g.popTransform();
        }
        if (player == null || player.isDead()) {
            g.pushTransform();
            g.setColor(new Color(0.4f, 0.4f, 0.4f, 0.6f));
            g.fillRect(0.0f, 0.0f, container.getWidth(), container.getHeight());
            g.drawImage(this.gameOverImage, (float)container.getWidth() / 2.0f - (float)this.gameOverImage.getWidth() / 2.0f, (float)container.getHeight() / 2.0f - (float)this.gameOverImage.getHeight() / 2.0f);
            g.popTransform();
        }
    }

    public void update(GameContainer container, StateBasedGame game, int dt) throws SlickException {
        Player player;
        if (MollysNightmare.isDeveloperMode() && 1000.0f / (float)dt < 40.0f) {
            System.out.println("Slow frame encountered: " + 1000 / dt + " FPS, " + dt + " ms.");
        }
        if ((player = this.world.getPlayer()) == null || player.isDead()) {
            if (container.getInput().isKeyPressed(28)) {
                this.init(container, game);
            }
            return;
        }
        if (player != null && !player.isDead() && player.hasWon()) {
            ++this.levelIndex;
            if (this.levelIndex > levelFiles.length - 1) {
                game.enterState(MollysNightmareState.end.ordinal());
                return;
            }
            this.initLevel(container, levelFiles[this.levelIndex]);
            return;
        }
        this.world.update(dt, container);
        final CollisionHandler collisions = new CollisionHandler(this.world);
        ArrayList<Entity> entities = new ArrayList<Entity>(this.world.getEntities().get());
        for (int i = 0; i < entities.size(); ++i) {
            Entity first = entities.get(i);
            for (int j = i + 1; j < entities.size(); ++j) {
                BoundingBox a = first.getBoundingBox();
                Entity second = entities.get(j);
                BoundingBox b = second.getBoundingBox();
                if (first instanceof Projectile && second instanceof NPC || first instanceof NPC && second instanceof Projectile) {
                    b = second.getActualBox();
                    a = first.getActualBox();
                }
                if (!a.intersects(first.getPos(), b, second.getPos())) continue;
                collisions.dispatch(first, second);
            }
            if (!this.world.getMap().isBlocked(first.getBoundingBox(), first.getPos())) continue;
            first.accept(new Visitor(){

                public void visit(Player player) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), player);
                }

                public void visit(NPC npc) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), npc);
                }

                public void visit(Projectile projectile) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), projectile);
                }

                public void visit(WallSocket wallSocket) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), wallSocket);
                }

                public void visit(GameDoor door) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), door);
                }

                public void visit(Boss boss) {
                    collisions.handle(MollysNightmareGame.this.world.getMap(), boss);
                }
            });
        }
    }

    public int getID() {
        return MollysNightmareState.game.ordinal();
    }
}

