/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.MollysNightmareState;
import game.engine.util.ImageUtil;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MollysNightmareTitle
extends BasicGameState {
    private MenuOption currentOption;
    private TitleState state;
    private Image titleImage;
    private Image newGameImage;
    private Image newGameSelectedImage;
    private Image aboutImage;
    private Image aboutSelectedImage;
    private Image exitImage;
    private Image exitSelectedImage;
    private int containerWidth;
    private Image aboutScreen1;
    private Image aboutScreen2;
    private Sound sound;

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.currentOption = MenuOption.start;
        this.state = TitleState.menu;
        this.containerWidth = container.getWidth();
        try {
            this.titleImage = ImageUtil.load("/assets/graphics/title.png");
            this.newGameImage = ImageUtil.load("/assets/graphics/new_game.png");
            this.newGameSelectedImage = ImageUtil.load("/assets/graphics/new_game_s.png");
            this.aboutImage = ImageUtil.load("/assets/graphics/about.png");
            this.aboutSelectedImage = ImageUtil.load("/assets/graphics/about_s.png");
            this.exitImage = ImageUtil.load("/assets/graphics/exit.png");
            this.exitSelectedImage = ImageUtil.load("/assets/graphics/exit_s.png");
            this.aboutScreen1 = ImageUtil.load("/assets/graphics/about_screen.png");
            this.aboutScreen2 = ImageUtil.load("/assets/graphics/about_screen2.png");
            this.sound = new Sound("/assets/audio/menuEffect1.wav");
        }
        catch (SlickException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.currentOption = MenuOption.start;
        this.state = TitleState.menu;
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.state == TitleState.menu) {
            if (container.getInput().isKeyPressed(28)) {
                container.getInput().clearKeyPressedRecord();
                switch (this.currentOption) {
                    case start: {
                        game.enterState(MollysNightmareState.game.ordinal());
                        this.sound.play();
                        return;
                    }
                    case information: {
                        this.state = TitleState.about;
                        this.sound.play();
                        return;
                    }
                    case exit: {
                        System.exit(0);
                        return;
                    }
                }
            } else if (container.getInput().isKeyPressed(208)) {
                int i = Math.min(MenuOption.values().length - 1, this.currentOption.ordinal() + 1);
                this.currentOption = MenuOption.values()[i];
                this.sound.play();
            } else if (container.getInput().isKeyPressed(200)) {
                int i = Math.max(0, this.currentOption.ordinal() - 1);
                this.currentOption = MenuOption.values()[i];
                this.sound.play();
            }
        } else if (this.state == TitleState.about) {
            if (container.getInput().isKeyPressed(28)) {
                this.state = TitleState.about2;
                container.getInput().clearKeyPressedRecord();
                this.sound.play();
            }
        } else if (this.state == TitleState.about2 && container.getInput().isKeyPressed(28)) {
            this.state = TitleState.menu;
            container.getInput().clearKeyPressedRecord();
            this.sound.play();
        }
    }

    public void setState(TitleState state) {
        this.state = state;
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.pushTransform();
        g.scale(2.0f, 2.0f);
        if (this.state == TitleState.menu) {
            int titleWidth = this.titleImage.getWidth();
            int titleHeight = this.titleImage.getHeight();
            int buttonWidth = this.newGameImage.getWidth();
            int buttonHeight = this.newGameImage.getHeight();
            switch (this.currentOption) {
                case start: {
                    g.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    g.drawImage(this.newGameSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    g.drawImage(this.aboutImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    g.drawImage(this.exitImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                    break;
                }
                case information: {
                    g.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    g.drawImage(this.newGameImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    g.drawImage(this.aboutSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    g.drawImage(this.exitImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                    break;
                }
                case exit: {
                    g.drawImage(this.titleImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)titleWidth)), 0.0f);
                    g.drawImage(this.newGameImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight));
                    g.drawImage(this.aboutImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + buttonHeight));
                    g.drawImage(this.exitSelectedImage, Math.round(0.5f * (0.5f * (float)this.containerWidth - (float)buttonWidth)), Math.round(titleHeight + 2 * buttonHeight));
                }
            }
        } else if (this.state == TitleState.about) {
            this.aboutScreen1.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        } else if (this.state == TitleState.about2) {
            this.aboutScreen2.draw(0.0f, 0.0f, (float)container.getWidth() / 2.0f, (float)container.getHeight() / 2.0f);
        }
        g.popTransform();
    }

    public int getID() {
        return MollysNightmareState.title.ordinal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MenuOption {
        start,
        information,
        exit;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleState {
        menu,
        about,
        about2;

    }
}

