/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.CollisionHandler;
import game.NightmareSpawner;
import game.TitleScreen;
import game.engine.BoundingBox;
import game.engine.GameCamera;
import game.engine.ObjectLoader;
import game.engine.util.CustomClasspathLocation;
import game.engine.util.ImageUtil;
import game.engine.util.LWJGLException;
import game.engine.util.LWJGLInstaller;
import game.engine.util.OperatingSystem;
import game.engine.util.YSortCompare;
import game.objects.Boss;
import game.objects.BossDoor;
import game.objects.GameDoor;
import game.objects.GameObject;
import game.objects.NPC;
import game.objects.Player;
import game.objects.Projectile;
import game.objects.TimedDoor;
import game.objects.WallSocket;
import game.objects.visitor.Visitor;
import game.world.GameWorld;
import game.world.MapException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.swing.JOptionPane;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.AppletGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.particles.ParticleSystem;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MolyJamGame
extends BasicGame {
    private static final int NUM_PROJ = 100;
    private static final String[] levelFiles = new String[]{"/assets/levels/arena.tmx", "/assets/levels/level1.tmx", "/assets/levels/level2.tmx"};
    private static boolean developerMode = false;
    private static boolean benchmarkMode = false;
    private static boolean skipInstall = false;
    private Random random;
    private GameWorld world;
    private GameCamera camera;
    private ArrayList<GameObject> gameObjects;
    private GameContainer gameContainer;
    private Player player;
    private ArrayList<Projectile> projectiles;
    private ObjectLoader objectLoader;
    private ParticleSystem particleSystem;
    private int projNr;
    private ArrayList<NPC> updateRequests;
    private NightmareSpawner nightmareSpawner;
    private SpriteSheet powerSheet;
    private SpriteSheet sanitySheet;
    private Image gameOverImage;
    private int levelIndex;
    private boolean loadNext;
    private TitleScreen titleScreen;
    private boolean showMenu;

    public static boolean isDeveloperMode() {
        return developerMode;
    }

    public static boolean setupNativeLibraries() {
        File gameDir = new File(System.getProperty("user.home"), MolyJamGame.class.getSimpleName());
        LWJGLInstaller installer = new LWJGLInstaller(gameDir);
        installer.setOperatingSystemArchive(OperatingSystem.windows, "/natives/windows_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.linux, "/natives/linux_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.macosx, "/natives/maxosx_natives.jar");
        installer.setOperatingSystemArchive(OperatingSystem.solaris, "/natives/solaris_natives.jar");
        OperatingSystem os = OperatingSystem.getCurrentOperatingSystem();
        if (os == null) {
            os = (OperatingSystem)((Object)JOptionPane.showInputDialog(null, "Your operating system could not be detected.\nPlease choose the closest match below.", "Cannot detect operating system", 1, null, (Object[])OperatingSystem.values(), (Object)OperatingSystem.windows));
        }
        if (os == null) {
            return false;
        }
        try {
            installer.install(os);
            return true;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not install native libraries.\n" + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) throws SlickException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--dev")) {
                developerMode = true;
                continue;
            }
            if (args[i].equals("--bench")) {
                benchmarkMode = true;
                continue;
            }
            if (!args[i].equals("--skipinstall")) continue;
            skipInstall = true;
        }
        if (!skipInstall && !MolyJamGame.setupNativeLibraries()) {
            System.exit(0);
        }
        ResourceLoader.addResourceLocation(new CustomClasspathLocation());
        Renderer.setRenderer(2);
        MolyJamGame jam = new MolyJamGame();
        AppGameContainer gameContainer = new AppGameContainer(jam, 800, 600, false);
        if (!benchmarkMode) {
            gameContainer.setTargetFrameRate(60);
        }
        if (!MolyJamGame.isDeveloperMode()) {
            gameContainer.setShowFPS(false);
        }
        gameContainer.start();
    }

    public MolyJamGame() {
        super("Molly's Nightmare - A MolyJam 2012 game");
    }

    @Override
    public void render(GameContainer container, Graphics g) throws SlickException {
        if (this.showMenu) {
            this.titleScreen.render(this, container, g);
            return;
        }
        g.pushTransform();
        this.camera.render(this, container, g);
        BoundingBox screenBounds = this.camera.getScreenBounds();
        Vector2f screenPos = this.camera.getScreenPos();
        this.world.renderLayers(g, GameWorld.LayerType.ground, screenBounds, screenPos);
        this.world.renderLayers(g, GameWorld.LayerType.wall, screenBounds, screenPos);
        this.world.renderLayers(g, GameWorld.LayerType.occlusion, screenBounds, screenPos);
        this.world.renderLayers(g, GameWorld.LayerType.object, screenBounds, screenPos);
        Collections.sort(this.gameObjects, new YSortCompare());
        for (GameObject object : this.gameObjects) {
            if (!object.getActualBox().intersects(object.getPos(), screenBounds, screenPos)) continue;
            g.pushTransform();
            Vector2f pos = object.getPos();
            g.translate(pos.x, pos.y);
            object.render(this, container, g);
            g.popTransform();
        }
        this.particleSystem.render();
        this.world.renderLayers(g, GameWorld.LayerType.roof, screenBounds, screenPos);
        g.popTransform();
        g.pushTransform();
        g.scale(2.0f, 2.0f);
        int healthStepSize = 20;
        int sanityId = Math.max(0, Math.min(this.player.getHealth() / healthStepSize, 4));
        int powerId = 0;
        if (this.player.getSocket() != null) {
            int powerStepSize = 20;
            powerId = this.player.getSocket().getCharge() == 0 ? 1 : Math.max(0, Math.min(this.player.getSocket().getCharge() / powerStepSize, 4)) + 2;
        }
        Image currentSanity = this.sanitySheet.getSprite(4 - sanityId, 0);
        currentSanity.draw(0.0f, (float)container.getHeight() / 2.0f - (float)currentSanity.getHeight());
        Image currentPower = this.powerSheet.getSprite(powerId, 0);
        currentPower.draw((float)container.getWidth() / 2.0f - (float)currentPower.getWidth(), (float)container.getHeight() / 2.0f - (float)currentPower.getHeight());
        g.popTransform();
        if (this.player.isDead()) {
            g.pushTransform();
            g.setColor(new Color(0.4f, 0.4f, 0.4f, 0.6f));
            g.fillRect(0.0f, 0.0f, container.getWidth(), container.getHeight());
            g.drawImage(this.gameOverImage, (float)container.getWidth() / 2.0f - (float)this.gameOverImage.getWidth() / 2.0f, (float)container.getHeight() / 2.0f - (float)this.gameOverImage.getHeight() / 2.0f);
            g.popTransform();
        }
    }

    @Override
    public void init(GameContainer container) throws SlickException {
        if (container instanceof AppletGameContainer.Container) {
            ResourceLoader.addResourceLocation(new CustomClasspathLocation());
            Renderer.setRenderer(2);
        }
        this.initMenu(container);
    }

    private void initMenu(GameContainer container) {
        this.titleScreen = new TitleScreen();
        this.titleScreen.init(this, container);
        this.showMenu = true;
    }

    private void initEndingMenu(GameContainer container) {
        this.initMenu(container);
        this.titleScreen.setState(TitleScreen.TitleState.menuEnding);
    }

    public void initGame(GameContainer container) throws SlickException {
        this.showMenu = false;
        this.initLevel(container, levelFiles[0]);
        this.levelIndex = 0;
        this.loadNext = false;
        Image powerImage = ImageUtil.load("/assets/graphics/power_sheet.png");
        Image sanityImage = ImageUtil.load("/assets/graphics/sanity_sheet.png");
        this.powerSheet = new SpriteSheet(powerImage, 64, 64);
        this.sanitySheet = new SpriteSheet(sanityImage, 64, 64);
        this.gameOverImage = ImageUtil.load("/assets/graphics/game_over_screen.png");
        this.random = new Random();
        this.gameContainer = container;
    }

    private void initLevel(GameContainer container, String level) throws SlickException {
        this.loadNext = false;
        this.gameObjects = new ArrayList();
        this.projectiles = new ArrayList();
        this.updateRequests = new ArrayList();
        this.objectLoader = new ObjectLoader();
        try {
            this.world = new GameWorld(new TiledMap(MolyJamGame.class.getResourceAsStream(level), "/assets/levels"));
        }
        catch (MapException e) {
            throw new SlickException("Failed to initialize map.", e);
        }
        int projectileType = 0;
        Projectile.ProjectileTypes[] projectileTypeValues = Projectile.ProjectileTypes.values();
        int nbrProjectileTypes = projectileTypeValues.length - 1;
        for (int i = 0; i < 99; ++i) {
            this.projectiles.add((Projectile)this.objectLoader.createObject(projectileTypeValues[projectileType++].name()));
            projectileType %= nbrProjectileTypes;
        }
        this.projectiles.add((Projectile)this.objectLoader.createObject("greenpixel"));
        this.camera = new GameCamera(2.0f);
        this.camera.init(this, container);
        HashMap<String, GameObject> namedObjects = new HashMap<String, GameObject>();
        HashMap<String, ArrayList<GameDoor>> doorMap = new HashMap<String, ArrayList<GameDoor>>();
        for (GameWorld.MapObject object : this.world.getObjects()) {
            ArrayList<GameDoor> tmp;
            BoundingBox dbb;
            Vector2f p;
            GameDoor door;
            BoundingBox rect;
            BoundingBox rect2;
            BoundingBox bb;
            if (object.isTypeOrName("spawn")) {
                this.player = (Player)this.objectLoader.createObject("player");
                BoundingBox rect3 = object.getRectangle();
                this.player.setPos(rect3.getCenterX(0.0f, 0.0f), rect3.getCenterY(0.0f, 0.0f));
                this.addGameObject(this.player);
                this.camera.attach(this.player);
                continue;
            }
            if (object.isTypeOrName("goal")) {
                this.world.setGoalBounds(object.getRectangle());
                continue;
            }
            if (object.getType().equalsIgnoreCase("npc")) {
                String npcName = object.getName().toLowerCase();
                NPC npc = (NPC)this.objectLoader.createObject(npcName);
                bb = npc.getBoundingBox();
                rect2 = object.getRectangle();
                npc.setPos(rect2.getCenterX(0.0f, 0.0f) - bb.getCenterX(0.0f, 0.0f), rect2.getCenterY(0.0f, 0.0f) - bb.getCenterY(0.0f, 0.0f));
                this.addGameObject(npc);
                continue;
            }
            if (object.isTypeOrName("wallsocket")) {
                WallSocket socket = (WallSocket)this.objectLoader.createObject("outlet");
                rect = object.getRectangle();
                try {
                    int doorTimer = Integer.parseInt(object.getProperty("timer", ""));
                    socket.setDoorTimer(doorTimer);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                socket.setPos(rect.getMinX(0.0f, 0.0f) + 8.0f, rect.getMinY(0.0f, 0.0f) + 8.0f);
                this.addGameObject(socket);
                String objectName = object.getProperty("name", "");
                if (objectName.isEmpty()) continue;
                namedObjects.put(objectName, socket);
                continue;
            }
            if (object.isTypeOrName("verticaldoor") || object.isTypeOrName("horizontaldoor")) {
                door = object.isTypeOrName("verticaldoor") ? (TimedDoor)this.objectLoader.createObject("verticaldoor") : (TimedDoor)this.objectLoader.createObject("horizontaldoor");
                rect = object.getRectangle();
                p = this.world.alignPosition(new Vector2f(rect.getCenterX(0.0f, 0.0f), rect.getCenterY(0.0f, 0.0f)));
                dbb = door.getBoundingBox();
                door.setPos(p.x - dbb.getCenterX(0.0f, 0.0f), p.y - dbb.getCenterY(0.0f, 0.0f));
                this.addGameObject(door);
                String socketName = object.getProperty("socket", "");
                if (socketName.isEmpty()) continue;
                tmp = (ArrayList<GameDoor>)doorMap.get(socketName);
                if (tmp == null) {
                    tmp = new ArrayList<GameDoor>();
                    doorMap.put(socketName, tmp);
                }
                tmp.add(door);
                continue;
            }
            if (object.isTypeOrName("verticalbossdoor") || object.isTypeOrName("horizontalbossdoor")) {
                door = object.isTypeOrName("verticalbossdoor") ? (BossDoor)this.objectLoader.createObject("verticalbossdoor") : (BossDoor)this.objectLoader.createObject("horizontalbossdoor");
                rect = object.getRectangle();
                p = this.world.alignPosition(new Vector2f(rect.getCenterX(0.0f, 0.0f), rect.getCenterY(0.0f, 0.0f)));
                dbb = door.getBoundingBox();
                door.setPos(p.x - dbb.getCenterX(0.0f, 0.0f), p.y - dbb.getCenterY(0.0f, 0.0f));
                this.addGameObject(door);
                String bossName = object.getProperty("boss", "");
                if (bossName.isEmpty()) continue;
                tmp = (ArrayList<GameDoor>)doorMap.get(bossName);
                if (tmp == null) {
                    tmp = new ArrayList<GameDoor>();
                    doorMap.put(bossName, tmp);
                }
                tmp.add(door);
                continue;
            }
            if (object.isTypeOrName("boss")) {
                String name = object.getName().toLowerCase();
                Boss boss = (Boss)this.objectLoader.createObject(name);
                bb = boss.getBoundingBox();
                rect2 = object.getRectangle();
                boss.setPos(rect2.getCenterX(0.0f, 0.0f) - bb.getCenterX(0.0f, 0.0f), rect2.getCenterY(0.0f, 0.0f) - bb.getCenterY(0.0f, 0.0f));
                this.addGameObject(boss);
                String objectName = object.getProperty("name", "");
                if (objectName.isEmpty()) continue;
                namedObjects.put(objectName, boss);
                continue;
            }
            System.out.println("WARNING: Unknown map object type " + object.getType() + ".");
        }
        for (String linkedName : doorMap.keySet()) {
            GameObject linkedObject = (GameObject)namedObjects.get(linkedName);
            if (linkedObject != null) {
                ArrayList doors = (ArrayList)doorMap.get(linkedName);
                for (GameDoor door : doors) {
                    if (door instanceof TimedDoor) {
                        TimedDoor tdoor = (TimedDoor)door;
                        WallSocket socket = (WallSocket)linkedObject;
                        tdoor.setSocket(socket);
                        int doorTimer = socket.getDoorTimer();
                        if (doorTimer <= 0) continue;
                        tdoor.setDoorTimer(doorTimer);
                        continue;
                    }
                    if (!(door instanceof BossDoor)) continue;
                    BossDoor bdoor = (BossDoor)door;
                    Boss boss = (Boss)linkedObject;
                    bdoor.setBoss(boss);
                }
                continue;
            }
            System.out.println("WARNING: Linked object for door not found. \"" + linkedName + "\".");
        }
        if (this.player == null) {
            System.err.println("ERROR: No player spawn location found on the map.");
            throw new SlickException("No player spawn location found.");
        }
        this.particleSystem = new ParticleSystem(ImageUtil.load("/assets/graphics/ribs.png"), 250);
        this.particleSystem.setRemoveCompletedEmitters(true);
        this.particleSystem.setBlendingMode(2);
        this.nightmareSpawner = new NightmareSpawner();
    }

    @Override
    public void update(GameContainer container, int dt) throws SlickException {
        if (MolyJamGame.isDeveloperMode() && 1000.0f / (float)dt < 40.0f) {
            System.out.println("Slow frame encountered: " + 1000 / dt + " FPS, " + dt + " ms.");
        }
        if (this.showMenu) {
            this.titleScreen.update(this, container, dt);
            return;
        }
        if (this.loadNext) {
            if (this.levelIndex > levelFiles.length - 1) {
                this.initEndingMenu(container);
                return;
            }
            this.initLevel(container, levelFiles[this.levelIndex]);
        }
        if (this.player.isDead() && container.getInput().isKeyPressed(28)) {
            this.initGame(container);
            return;
        }
        if (this.player.hasWon()) {
            this.levelIndex = (this.levelIndex + 1) % levelFiles.length;
            this.initLevel(container, levelFiles[this.levelIndex]);
            return;
        }
        this.nightmareSpawner.update(this, container, dt);
        if (this.updateRequests.size() > 0) {
            this.updateRequests.remove(0).updatePath(this, dt);
        }
        ArrayList<GameObject> updateList = new ArrayList<GameObject>();
        updateList.addAll(this.gameObjects);
        for (GameObject object : updateList) {
            object.update(this, container, dt);
        }
        final CollisionHandler collisions = new CollisionHandler(this);
        for (int i = 0; i < updateList.size(); ++i) {
            GameObject first = (GameObject)updateList.get(i);
            for (int j = i + 1; j < updateList.size(); ++j) {
                BoundingBox a = first.getBoundingBox();
                GameObject second = (GameObject)updateList.get(j);
                BoundingBox b = second.getBoundingBox();
                if (first instanceof Projectile && second instanceof NPC || first instanceof NPC && second instanceof Projectile) {
                    b = second.getActualBox();
                    a = first.getActualBox();
                }
                if (!a.intersects(first.getPos(), b, second.getPos())) continue;
                collisions.dispatch(first, second);
            }
            if (!this.world.isBlocked(first.getBoundingBox(), first.getPos())) continue;
            first.accept(new Visitor(){

                public void visit(Player player) {
                    collisions.handle(MolyJamGame.this.world, player);
                }

                public void visit(NPC npc) {
                    collisions.handle(MolyJamGame.this.world, npc);
                }

                public void visit(Projectile projectile) {
                    collisions.handle(MolyJamGame.this.world, projectile);
                }

                public void visit(WallSocket wallSocket) {
                    collisions.handle(MolyJamGame.this.world, wallSocket);
                }

                public void visit(GameDoor door) {
                    collisions.handle(MolyJamGame.this.world, door);
                }

                public void visit(Boss boss) {
                    collisions.handle(MolyJamGame.this.world, boss);
                }
            });
        }
        this.camera.update(this, container, dt);
        this.particleSystem.update(dt);
    }

    public void addGameObject(GameObject go) {
        this.gameObjects.add(go);
        go.init(this, this.gameContainer);
    }

    public GameCamera getCamera() {
        return this.camera;
    }

    public GameWorld getWorld() {
        return this.world;
    }

    public ArrayList<GameObject> getGameObjects() {
        return this.gameObjects;
    }

    public ArrayList<WallSocket> getWallSockets() {
        ArrayList<GameObject> objs = this.getGameObjects();
        ArrayList<WallSocket> sockets = new ArrayList<WallSocket>();
        for (GameObject obj : objs) {
            if (!(obj instanceof WallSocket)) continue;
            sockets.add((WallSocket)obj);
        }
        return sockets;
    }

    public ArrayList<GameDoor> getGameDoors() {
        ArrayList<GameObject> objs = this.getGameObjects();
        ArrayList<GameDoor> doors = new ArrayList<GameDoor>();
        for (GameObject obj : objs) {
            if (!(obj instanceof GameDoor)) continue;
            doors.add((GameDoor)obj);
        }
        return doors;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Random getRandom() {
        return this.random;
    }

    public void spawnShot(Vector2f pos, Vector2f dir) {
        Projectile pew = this.projectiles.get(this.projNr);
        ++this.projNr;
        this.projNr %= 100;
        pew.reinit(pos, dir, Projectile.Target.enemy);
        if (!this.gameObjects.contains(pew)) {
            this.gameObjects.add(pew);
        }
    }

    public void despawn(GameObject obj) {
        this.gameObjects.remove(obj);
    }

    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public void requestPathUpdate(NPC npc) {
        this.updateRequests.add(npc);
    }

    public ObjectLoader getObjectLoader() {
        return this.objectLoader;
    }

    public void nextLevel() {
        this.loadNext = true;
        ++this.levelIndex;
    }

    public ArrayList<GameObject> getSolidBlockingObjects() {
        ArrayList<GameObject> solids = new ArrayList<GameObject>();
        for (GameObject go : this.gameObjects) {
            if (!go.isSolidBlocking()) continue;
            solids.add(go);
        }
        return solids;
    }
}

