/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.engine.BoundingBox;
import game.entities.Character;
import game.entities.Entity;
import game.world.GameWorld;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.pathfinding.Mover;
import org.newdawn.slick.util.pathfinding.PathFindingContext;
import org.newdawn.slick.util.pathfinding.TileBasedMap;

public class TileBasedMapAdapter
implements TileBasedMap {
    private GameWorld world;
    private float tileSize;

    public TileBasedMapAdapter(GameWorld world, float tileSize) {
        this.world = world;
        this.tileSize = tileSize;
    }

    private Character getCharacter(PathFindingContext ctx) {
        return ((TileBasedMover)ctx.getMover()).getCharacter();
    }

    private Vector2f getPosition(int tx, int ty) {
        return new Vector2f((float)tx * this.tileSize, (float)ty * this.tileSize);
    }

    public boolean blocked(PathFindingContext ctx, int tx, int ty) {
        Character character = this.getCharacter(ctx);
        BoundingBox cbb = character.getBoundingBox();
        Vector2f cpos = this.getPosition(tx, ty);
        if (this.world.getMap().isBlocked(cbb, cpos)) {
            return true;
        }
        boolean collidesWithObject = false;
        for (Entity o : this.world.getEntities().get()) {
            if (o == character || o == this.world.getPlayer() || !o.isSolidBlocking() || !o.getBoundingBox().intersects(o.getPos(), cbb, cpos)) continue;
            collidesWithObject = true;
        }
        return collidesWithObject;
    }

    public float getCost(PathFindingContext ctx, int tx, int ty) {
        Character character = this.getCharacter(ctx);
        boolean closeToBlocking = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BoundingBox cbb = character.getBoundingBox();
                if (!this.world.getMap().isBlocked(cbb, this.getPosition(tx + i, ty + j))) continue;
                closeToBlocking = true;
            }
        }
        boolean collidesWithObject = false;
        BoundingBox cbb = character.getBoundingBox();
        Vector2f cpos = this.getPosition(tx, ty);
        for (Entity o : this.world.getEntities().get()) {
            if (o == character || o == this.world.getPlayer() || !o.getBoundingBox().intersects(o.getPos(), cbb, cpos)) continue;
            collidesWithObject = true;
        }
        return (closeToBlocking ? 3 : 1) + (collidesWithObject ? 5 : 0);
    }

    public int getHeightInTiles() {
        return (int)(this.world.getMap().getBounds().getHeight() / this.tileSize);
    }

    public int getWidthInTiles() {
        return (int)(this.world.getMap().getBounds().getWidth() / this.tileSize);
    }

    public void pathFinderVisited(int tx, int ty) {
    }

    public static class TileBasedMover
    implements Mover {
        private Character character;

        public TileBasedMover(Character character) {
            this.character = character;
        }

        public Character getCharacter() {
            return this.character;
        }
    }
}

